/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.ui;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.MetricData;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceValue;
import com.singularity.ee.controller.api.dto.ui.GraphData;

@UiCodeGen
@TSCodeGen(exclude=true)
public class MetricViewData {
    private long metricId;
    private String name;
    private float value;
    private float sum;
    private long count;
    private GraphData graphData;

    public MetricViewData(PerformanceValue performanceValue, MetricData metricData, boolean setGraphDataNullsToZero) {
        if (performanceValue != null) {
            this.metricId = performanceValue.getMetricId();
            this.value = performanceValue.getValue();
        } else if (metricData != null) {
            this.metricId = metricData.getMetricId();
            this.name = metricData.getMetricName();
        }
        this.graphData = new GraphData(metricData, setGraphDataNullsToZero);
    }

    public MetricViewData(PerformanceValue performanceValue, MetricData metricData) {
        this(performanceValue, metricData, false);
    }

    public MetricViewData(long metricId, float value, String name, GraphData graphData) {
        this.metricId = metricId;
        this.value = value;
        this.name = name;
        this.graphData = graphData;
    }

    public MetricViewData() {
        this.metricId = -1L;
        this.value = -1.0f;
        this.name = null;
        this.graphData = null;
    }

    public long getMetricId() {
        return this.metricId;
    }

    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getSum() {
        return this.sum;
    }

    public void setSum(float sum) {
        this.sum = sum;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GraphData getGraphData() {
        return this.graphData;
    }

    public void setGraphData(GraphData graphData) {
        this.graphData = graphData;
    }

    public void setMetricDataFromRolledUpData(MetricData rolledUpData) {
        try {
            this.metricId = rolledUpData.getMetricId();
            this.name = rolledUpData.getMetricName();
            MetricDataTimeslice[] rolledUpDataDataTimeslices = rolledUpData.getDataTimeslices();
            if (rolledUpDataDataTimeslices.length > 0) {
                this.value = rolledUpDataDataTimeslices[0].getMetricValue().getValue();
                this.sum = rolledUpDataDataTimeslices[0].getMetricValue().getSum();
                this.count = rolledUpDataDataTimeslices[0].getMetricValue().getCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMetricDataFromSeriesData(MetricData seriesData, boolean setGraphDataNullsToZero) {
        try {
            this.graphData = new GraphData(seriesData, setGraphDataNullsToZero);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

