/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.ui;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.MetricDataFrequency;
import com.singularity.ee.controller.api.constants.MetricDataFrequencyHelper;
import com.singularity.ee.controller.api.dto.MetricData;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import java.util.Iterator;
import java.util.Map;

@UiCodeGen
@TSCodeGen(exclude=true)
public class GraphData {
    private long startTime;
    private long interval;
    private Long[] data;

    public GraphData(MetricData metricData, boolean setNullsToZero) {
        if (metricData != null) {
            MetricDataTimeslice[] timeslices = metricData.getDataTimeslices();
            if (timeslices != null && timeslices.length > 0) {
                this.startTime = timeslices[0].getStartTime().getTime();
            }
            this.data = new Long[timeslices.length];
            for (int i = 0; i < timeslices.length; ++i) {
                this.data[i] = timeslices[i].getMetricValue() != null ? Long.valueOf(timeslices[i].getMetricValue().getValue()) : (setNullsToZero ? Long.valueOf(0L) : null);
            }
            this.interval = metricData.getFrequency() == MetricDataFrequency.CUSTOM ? metricData.getGranularityMinutes() : (long)MetricDataFrequencyHelper.getFrequencyMinutes(metricData.getFrequency());
        }
    }

    public GraphData(MetricData metricData) {
        this(metricData, false);
    }

    public GraphData(Map<String, Long> valueMap, long startTime, long interval, boolean setNullsToZero) {
        long latestTime = startTime;
        Iterator<String> iterator = valueMap.keySet().iterator();
        while (iterator.hasNext()) {
            long time = Long.parseLong(iterator.next());
            if (latestTime < time) {
                latestTime = time;
            }
            if (startTime <= time) continue;
            startTime = time;
        }
        this.startTime = startTime;
        this.data = new Long[(int)((latestTime - startTime) / interval) + 1];
        this.interval = interval;
        for (String key : valueMap.keySet()) {
            long time = Long.parseLong(key);
            int index = (int)((time - startTime) / interval);
            this.data[index] = (long)valueMap.get(key);
        }
        if (setNullsToZero) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = 0L;
            }
        }
    }

    public GraphData(long startTime, long interval, Long[] data) {
        this.startTime = startTime;
        this.interval = interval;
        this.data = data;
    }

    public GraphData() {
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public Long[] getData() {
        return this.data;
    }

    public void setData(Long[] data) {
        this.data = data;
    }

    public long calculateTotal() {
        long runningSum = 0L;
        if (this.data != null) {
            for (Long dataElement : this.data) {
                if (dataElement == null) continue;
                runningSum += dataElement.longValue();
            }
        }
        return runningSum;
    }
}

