/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;

@UiCodeGen
@TSCodeGen(exclude=true)
public class TransactionStats {
    private float timeConsumedPerTransaction;
    private float errorsPercentage;
    private float callsPerTransaction;
    private int numberOfCalls;
    private int numberOfErrors;

    public TransactionStats() {
    }

    public TransactionStats(float timeConsumedPerTransaction, float errorsPercentage, float callsPerTransaction) {
        this.timeConsumedPerTransaction = timeConsumedPerTransaction;
        this.errorsPercentage = errorsPercentage;
        this.callsPerTransaction = callsPerTransaction;
    }

    public TransactionStats(float timeConsumedPerTransaction, float errorsPercentage, float callsPerTransaction, int numberOfCalls, int numberOfErrors) {
        this(timeConsumedPerTransaction, errorsPercentage, callsPerTransaction);
        this.numberOfCalls = numberOfCalls;
        this.numberOfErrors = numberOfErrors;
    }

    public float getTimeConsumedPerTransaction() {
        return this.timeConsumedPerTransaction;
    }

    public void setTimeConsumedPerTransaction(float timeConsumedPerTransaction) {
        this.timeConsumedPerTransaction = timeConsumedPerTransaction;
    }

    public float getErrorsPercentage() {
        return this.errorsPercentage;
    }

    public void setErrorsPercentage(float errorsPercentage) {
        this.errorsPercentage = errorsPercentage;
    }

    public float getCallsPerTransaction() {
        return this.callsPerTransaction;
    }

    public void setCallsPerTransaction(float callsPerTransaction) {
        this.callsPerTransaction = callsPerTransaction;
    }

    public void addToNumberOfCalls(int calls) {
        this.numberOfCalls += calls;
    }

    public void addToNumberOfErrors(int errors) {
        this.numberOfErrors += errors;
    }

    public void addToTimeConsumedPerTransaction(float timeConsumed) {
        this.timeConsumedPerTransaction += timeConsumed;
    }

    public void subtractFromTimeConsumedPerTransaction(float timeConsumed, boolean protectFromNegativeTime) {
        if (protectFromNegativeTime && this.timeConsumedPerTransaction < timeConsumed) {
            return;
        }
        this.timeConsumedPerTransaction -= timeConsumed;
    }

    public void subtractFromTimeConsumedPerTransaction(float timeConsumed) {
        this.subtractFromTimeConsumedPerTransaction(timeConsumed, false);
    }

    public void calculateErrorsPercentage() {
        if (this.numberOfCalls == 0) {
            return;
        }
        this.setErrorsPercentage((float)this.numberOfErrors / (float)this.numberOfCalls * 100.0f);
    }

    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public void setNumberOfCalls(int numberOfCalls) {
        this.numberOfCalls = numberOfCalls;
    }

    public String toString() {
        return "[Time/Txn:" + this.timeConsumedPerTransaction + " E%:" + this.errorsPercentage + " Calls/Txn:" + this.callsPerTransaction + " NoC:" + this.numberOfCalls + " NoE:" + this.numberOfErrors + "]";
    }
}

