/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceValue;

@UiCodeGen
@TSCodeGen(exclude=true)
public class PerformanceStats {
    private PerformanceValue averageResponseTime;
    private PerformanceValue endToEndLatencyTime;
    private PerformanceValue callsPerMinute;
    private PerformanceValue errorsPerMinute;
    private PerformanceValue numberOfErrors;
    private PerformanceValue numberOfCalls;
    private boolean artDefined;

    public PerformanceStats() {
    }

    public PerformanceStats(float ART, float NoC, float NoE, float CpM, float EpM) {
        this.averageResponseTime = new PerformanceValue(-1L, ART);
        this.callsPerMinute = new PerformanceValue(-1L, CpM);
        this.errorsPerMinute = new PerformanceValue(-1L, EpM);
        this.numberOfErrors = new PerformanceValue(-1L, NoE);
        this.numberOfCalls = new PerformanceValue(-1L, NoC);
    }

    public PerformanceStats(PerformanceStats stats) {
        this(stats.averageResponseTime.getValue(), stats.numberOfCalls.getValue(), stats.numberOfErrors.getValue(), stats.callsPerMinute.getValue(), stats.errorsPerMinute.getValue());
    }

    public PerformanceValue getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public void setAverageResponseTime(PerformanceValue averageResponseTime) {
        this.averageResponseTime = averageResponseTime;
    }

    public PerformanceValue getEndToEndLatencyTime() {
        return this.endToEndLatencyTime;
    }

    public void setEndToEndLatencyTime(PerformanceValue endToEndLatencyTime) {
        this.endToEndLatencyTime = endToEndLatencyTime;
    }

    public PerformanceValue getCallsPerMinute() {
        return this.callsPerMinute;
    }

    public void setCallsPerMinute(PerformanceValue callsPerMinute) {
        this.callsPerMinute = callsPerMinute;
    }

    public PerformanceValue getErrorsPerMinute() {
        return this.errorsPerMinute;
    }

    public void setErrorsPerMinute(PerformanceValue errorsPerMinute) {
        this.errorsPerMinute = errorsPerMinute;
    }

    public PerformanceValue getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(PerformanceValue numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public PerformanceValue getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public void setNumberOfCalls(PerformanceValue numberOfCalls) {
        this.numberOfCalls = numberOfCalls;
    }

    @JsonIgnore
    public float getErrorPercentage() {
        PerformanceValue noc = this.getNumberOfCalls();
        PerformanceValue noe = this.getNumberOfErrors();
        if (noc == null || noe == null || noc.getValue() <= 0.0f || noe.getValue() <= 0.0f) {
            return 0.0f;
        }
        return noe.getValue() / noc.getValue() * 100.0f;
    }

    public boolean isArtDefined() {
        return this.artDefined;
    }

    public void setArtDefined(boolean defined) {
        this.artDefined = defined;
    }

    public static PerformanceStats createEmptyStats() {
        PerformanceStats stats = new PerformanceStats();
        stats.setAverageResponseTime(PerformanceValue.createEmptyValue());
        stats.setCallsPerMinute(PerformanceValue.createEmptyValue());
        stats.setErrorsPerMinute(PerformanceValue.createEmptyValue());
        stats.setNumberOfCalls(PerformanceValue.createEmptyValue());
        stats.setNumberOfErrors(PerformanceValue.createEmptyValue());
        stats.setEndToEndLatencyTime(PerformanceValue.createEmptyValue());
        return stats;
    }

    public String toString() {
        return "[ART:" + this.averageResponseTime + " CpM:" + this.callsPerMinute + " EpM:" + this.errorsPerMinute + " NoC:" + this.numberOfCalls + " NoE:" + this.numberOfErrors + "]";
    }

    public PerformanceStats copy() {
        PerformanceStats copy = new PerformanceStats();
        copy.setArtDefined(this.artDefined);
        copy.setAverageResponseTime(PerformanceValue.safeCopy((PerformanceValue)this.averageResponseTime));
        copy.setCallsPerMinute(PerformanceValue.safeCopy((PerformanceValue)this.callsPerMinute));
        copy.setErrorsPerMinute(PerformanceValue.safeCopy((PerformanceValue)this.errorsPerMinute));
        copy.setNumberOfCalls(PerformanceValue.safeCopy((PerformanceValue)this.numberOfCalls));
        copy.setNumberOfErrors(PerformanceValue.safeCopy((PerformanceValue)this.numberOfErrors));
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PerformanceStats)) {
            return false;
        }
        PerformanceStats performanceStats = (PerformanceStats)obj;
        return (this.averageResponseTime == null ? performanceStats.averageResponseTime == null : this.averageResponseTime.equals((Object)performanceStats.averageResponseTime)) && (this.callsPerMinute == null ? performanceStats.callsPerMinute == null : this.callsPerMinute.equals((Object)performanceStats.callsPerMinute)) && (this.errorsPerMinute == null ? performanceStats.errorsPerMinute == null : this.errorsPerMinute.equals((Object)performanceStats.errorsPerMinute)) && (this.numberOfCalls == null ? performanceStats.numberOfCalls == null : this.numberOfCalls.equals((Object)performanceStats.numberOfCalls)) && (this.numberOfErrors == null ? performanceStats.numberOfErrors == null : this.numberOfErrors.equals((Object)performanceStats.numberOfErrors)) && this.artDefined == performanceStats.artDefined;
    }

    public int hashCode() {
        throw new RuntimeException("PerformanceStats hashCode not implemented");
    }
}

