/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ApplicationComponentExitStats;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ApplicationComponentThreadStats;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceStats;

@UiCodeGen
@TSCodeGen(exclude=true)
public class ApplicationComponentNodeStats {
    private long nodeId;
    private PerformanceStats perfStats;
    private PerformanceStats baselineStats;
    private ApplicationComponentExitStats[] exitStats;
    private ApplicationComponentThreadStats[] threadStats;

    public ApplicationComponentNodeStats(long id, PerformanceStats perfStats) {
        this.nodeId = id;
        this.perfStats = perfStats;
        this.baselineStats = PerformanceStats.createEmptyStats();
    }

    public ApplicationComponentNodeStats() {
    }

    public ApplicationComponentNodeStats copy() {
        int i;
        PerformanceStats baselineStats;
        ApplicationComponentNodeStats copy = new ApplicationComponentNodeStats();
        copy.setNodeId(this.getNodeId());
        PerformanceStats perfStats = this.getPerfStats();
        if (perfStats != null) {
            copy.setPerfStats(perfStats.copy());
        }
        if ((baselineStats = this.getBaselineStats()) != null) {
            copy.setBaselineStats(baselineStats.copy());
        }
        if (this.exitStats != null) {
            ApplicationComponentExitStats[] copyExitStats = new ApplicationComponentExitStats[this.exitStats.length];
            for (i = 0; i < this.exitStats.length; ++i) {
                ApplicationComponentExitStats exitStat = this.exitStats[i];
                if (exitStat == null) continue;
                copyExitStats[i] = exitStat.copy();
            }
            copy.setExitStats(copyExitStats);
        }
        if (this.threadStats != null) {
            ApplicationComponentThreadStats[] copyThreadStats = new ApplicationComponentThreadStats[this.threadStats.length];
            for (i = 0; i < this.threadStats.length; ++i) {
                ApplicationComponentThreadStats threadStat = this.threadStats[i];
                if (threadStat == null) continue;
                copyThreadStats[i] = threadStat.copy();
            }
            copy.setThreadStats(copyThreadStats);
        }
        return copy;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long id) {
        this.nodeId = id;
    }

    public PerformanceStats getPerfStats() {
        return this.perfStats;
    }

    public void setPerfStats(PerformanceStats perfStats) {
        this.perfStats = perfStats;
    }

    public PerformanceStats getBaselineStats() {
        return this.baselineStats;
    }

    public void setBaselineStats(PerformanceStats baselineStats) {
        this.baselineStats = baselineStats;
    }

    public ApplicationComponentExitStats[] getExitStats() {
        return this.exitStats;
    }

    public void setExitStats(ApplicationComponentExitStats ... exitStats) {
        this.exitStats = exitStats;
    }

    public ApplicationComponentThreadStats[] getThreadStats() {
        return this.threadStats;
    }

    public void setThreadStats(ApplicationComponentThreadStats ... threadStats) {
        this.threadStats = threadStats;
    }

    public String toString() {
        char NEW_LINE = '\n';
        StringBuilder strBuff = new StringBuilder().append("[Node Id:").append(this.getNodeId()).append(", perf stats:").append(this.getPerfStats());
        if (this.getBaselineStats() != null) {
            strBuff.append(", baseline stats:").append(this.getBaselineStats());
        }
        strBuff.append(NEW_LINE);
        if (this.exitStats != null) {
            String EXIT_STATS_TAB = "    Exit Stats:";
            for (ApplicationComponentExitStats exitStat : this.exitStats) {
                strBuff.append(EXIT_STATS_TAB).append(exitStat).append(NEW_LINE);
            }
        }
        return strBuff.toString();
    }
}

