/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.TimeRange;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.transactionmonitor.RSDDataCollectorFilter;
import com.singularity.ee.controller.api.dto.transactionmonitor.ServerCursor;

@UiCodeGen
@TSCodeGen(exclude=true)
public class RequestSegmentDataFilter {
    private boolean archived;
    private long[] applicationIds;
    private long[] applicationComponentIds;
    private long[] applicationComponentNodeIds;
    private long[] businessTransactionIds;
    private String[] deepDivePolicy;
    private String[] userExperience;
    private String[] guids;
    private String[] diagnosticSessionGuid;
    private long[] reqIds;
    private boolean firstInChain;
    private boolean errorOccured;
    private boolean hasDeepDiveData;
    private String sessionId;
    private String userPrincipalId;
    private String url;
    private long executionTimeInMilis;
    private long startingRequestId;
    private long endRequestId;
    private long[] errorIDs;
    private long[] sepIds;
    private RSDDataCollectorFilter dataCollectorFilter;
    private int maxRows;
    private TimeRangeSpecifier rangeSpecifier;
    private boolean needSnaphotData;
    private boolean needProps;
    private boolean needExitCalls;
    private boolean preserveAsyncEndExits;
    private ServerCursor serverCursor;
    private boolean diagnosticSnapshot;
    private boolean badRequest;
    private String[] endToEndUserExperience;
    private boolean forceV1Search = false;
    private long endToEndLatency = -1L;

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public long[] getApplicationIds() {
        return this.applicationIds;
    }

    public void setApplicationIds(long[] applicationIds) {
        this.applicationIds = applicationIds;
    }

    public long[] getApplicationComponentIds() {
        return this.applicationComponentIds;
    }

    public void setApplicationComponentIds(long[] applicationComponentIds) {
        this.applicationComponentIds = applicationComponentIds;
    }

    public long[] getApplicationComponentNodeIds() {
        return this.applicationComponentNodeIds;
    }

    public void setApplicationComponentNodeIds(long[] applicationComponentNodeIds) {
        this.applicationComponentNodeIds = applicationComponentNodeIds;
    }

    public long[] getBusinessTransactionIds() {
        return this.businessTransactionIds;
    }

    public void setBusinessTransactionIds(long[] businessTransactionIds) {
        this.businessTransactionIds = businessTransactionIds;
    }

    public String[] getDeepDivePolicy() {
        return this.deepDivePolicy;
    }

    public void setDeepDivePolicy(String[] deepDivePolicy) {
        this.deepDivePolicy = deepDivePolicy;
    }

    public String[] getUserExperience() {
        return this.userExperience;
    }

    public void setUserExperience(String[] userExperience) {
        this.userExperience = userExperience;
    }

    public String[] getGuids() {
        return this.guids;
    }

    public void setGuids(String ... guids) {
        this.guids = guids;
    }

    public String[] getDiagnosticSessionGuid() {
        return this.diagnosticSessionGuid;
    }

    public void setDiagnosticSessionGuid(String[] diagnosticSessionGuid) {
        this.diagnosticSessionGuid = diagnosticSessionGuid;
    }

    public long[] getReqIds() {
        return this.reqIds;
    }

    public void setReqIds(long[] reqIds) {
        this.reqIds = reqIds;
    }

    public boolean isFirstInChain() {
        return this.firstInChain;
    }

    public void setFirstInChain(boolean firstInChain) {
        this.firstInChain = firstInChain;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    public boolean isHasDeepDiveData() {
        return this.hasDeepDiveData;
    }

    public void setHasDeepDiveData(boolean hasDeepDiveData) {
        this.hasDeepDiveData = hasDeepDiveData;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getUserPrincipalId() {
        return this.userPrincipalId;
    }

    public void setUserPrincipalId(String userPrincipalId) {
        this.userPrincipalId = userPrincipalId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getExecutionTimeInMilis() {
        return this.executionTimeInMilis;
    }

    public void setExecutionTimeInMilis(long executionTimeInMilis) {
        this.executionTimeInMilis = executionTimeInMilis;
    }

    public long getStartingRequestId() {
        return this.startingRequestId;
    }

    public void setStartingRequestId(long startingRequestId) {
        this.startingRequestId = startingRequestId;
    }

    public long getEndRequestId() {
        return this.endRequestId;
    }

    public void setEndRequestId(long endRequestId) {
        this.endRequestId = endRequestId;
    }

    public long[] getErrorIDs() {
        return this.errorIDs;
    }

    public void setErrorIDs(long[] errorIDs) {
        this.errorIDs = errorIDs;
    }

    public long[] getSepIds() {
        return this.sepIds;
    }

    public void setSepIds(long[] sepIds) {
        this.sepIds = sepIds;
    }

    public RSDDataCollectorFilter getDataCollectorFilter() {
        return this.dataCollectorFilter;
    }

    public void setDataCollectorFilter(RSDDataCollectorFilter dataCollectorFilter) {
        this.dataCollectorFilter = dataCollectorFilter;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public TimeRangeSpecifier getRangeSpecifier() {
        return this.rangeSpecifier;
    }

    public void setRangeSpecifier(TimeRangeSpecifier rangeSpecifier) {
        this.rangeSpecifier = rangeSpecifier;
    }

    public boolean isNeedSnaphotData() {
        return this.needSnaphotData;
    }

    public void setNeedSnaphotData(boolean needSnaphotData) {
        this.needSnaphotData = needSnaphotData;
    }

    public boolean isNeedProps() {
        return this.needProps;
    }

    public void setNeedProps(boolean needProps) {
        this.needProps = needProps;
    }

    public boolean isNeedExitCalls() {
        return this.needExitCalls;
    }

    public void setNeedExitCalls(boolean needExitCalls) {
        this.needExitCalls = needExitCalls;
    }

    public boolean isPreserveAsyncEndExits() {
        return this.preserveAsyncEndExits;
    }

    public void setPreserveAsyncEndExits(boolean preserveAsyncEndExits) {
        this.preserveAsyncEndExits = preserveAsyncEndExits;
    }

    public ServerCursor getServerCursor() {
        return this.serverCursor;
    }

    public void setServerCursor(ServerCursor serverCursor) {
        this.serverCursor = serverCursor;
    }

    public boolean isDiagnosticSnapshot() {
        return this.diagnosticSnapshot;
    }

    public void setDiagnosticSnapshot(boolean diagnosticSnapshot) {
        this.diagnosticSnapshot = diagnosticSnapshot;
    }

    public boolean isBadRequest() {
        return this.badRequest;
    }

    public void setBadRequest(boolean badRequest) {
        this.badRequest = badRequest;
    }

    public void setEndToEndUserExperience(String[] endToEndUserExperience) {
        this.endToEndUserExperience = endToEndUserExperience;
    }

    public String[] getEndToEndUserExperience() {
        return this.endToEndUserExperience;
    }

    public long getEndToEndLatency() {
        return this.endToEndLatency;
    }

    public void setEndToEndLatency(long endToEndLatency) {
        this.endToEndLatency = endToEndLatency;
    }

    public boolean isForceV1Search() {
        return this.forceV1Search;
    }

    public void setForceV1Search(boolean forceV1Search) {
        this.forceV1Search = forceV1Search;
    }

    public boolean hasProps() {
        boolean result = false;
        if (this.getErrorIDs() != null && this.getErrorIDs().length > 0) {
            result = true;
        }
        if (this.getSepIds() != null && this.getSepIds().length > 0) {
            return true;
        }
        if (this.getDataCollectorFilter() != null) {
            result = true;
        }
        return result;
    }

    public boolean isCacheable(int latestRequestTime, int hoursInCache) {
        if (this.getGuids() != null && this.getGuids().length > 0) {
            return false;
        }
        if (this.isArchived()) {
            return false;
        }
        if (this.getRangeSpecifier() == null) {
            return false;
        }
        TimeRange range = this.getRangeSpecifier().getTimeRange();
        int startTime = (int)(range.getStartTime().getTime() / 60000L);
        return latestRequestTime - startTime <= hoursInCache * 60;
    }

    public boolean hasNonCacheableItems() {
        if (this.getGuids() != null && this.getGuids().length > 0) {
            return true;
        }
        if (this.isDiagnosticSnapshot()) {
            return true;
        }
        if (this.isArchived()) {
            return true;
        }
        if (this.getExecutionTimeInMilis() > 0L) {
            return true;
        }
        if (this.getSessionId() != null) {
            return true;
        }
        if (this.getUserPrincipalId() != null) {
            return true;
        }
        if (this.getUrl() != null) {
            return true;
        }
        long[] errorIds = this.getErrorIDs();
        if (errorIds != null && errorIds.length > 0) {
            return true;
        }
        long[] sepIds = this.getSepIds();
        if (sepIds != null && sepIds.length > 0) {
            return true;
        }
        return this.getDataCollectorFilter() != null;
    }

    public boolean isRsdScrollIdSet() {
        return this.serverCursor != null && this.serverCursor.getScrollId() > 0L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("RequestSegmentDataFilter:").append("\n");
        result.append("  archived = ").append(this.archived).append("\n");
        result.append("  deepDivePolicy =");
        if (this.deepDivePolicy != null) {
            for (String ddp : this.deepDivePolicy) {
                result.append("\t").append(ddp);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  applicationIds =");
        if (this.applicationIds != null) {
            for (long id : this.applicationIds) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  applicationComponentIds =");
        if (this.applicationComponentIds != null) {
            for (long id : this.applicationComponentIds) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  applicationComponentNodeIds =");
        if (this.applicationComponentNodeIds != null) {
            for (long id : this.applicationComponentNodeIds) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  businessTransactionIds =");
        if (this.businessTransactionIds != null) {
            for (long id : this.businessTransactionIds) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  userExperience =");
        if (this.userExperience != null) {
            for (String ue : this.userExperience) {
                result.append("\t").append(ue);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" e2eUserExperience =");
        if (this.endToEndUserExperience != null) {
            for (String e2eUE : this.endToEndUserExperience) {
                result.append("\t").append(e2eUE);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" e2eLatency =").append(this.endToEndLatency).append("\n");
        result.append("  maxRows = ").append(this.maxRows).append("\n");
        result.append("  rangeSpecifier = ");
        if (this.rangeSpecifier != null) {
            result.append(this.rangeSpecifier.toString()).append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  guids =");
        if (this.guids != null) {
            for (String guid : this.guids) {
                result.append("\t").append(guid);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  firstInChain = ").append(this.firstInChain).append("\n");
        result.append("  needProps = ").append(this.needProps).append("\n");
        result.append("  needExitCalls = ").append(this.needExitCalls).append("\n");
        result.append("  executionTimeInMilis = ").append(this.executionTimeInMilis).append("\n");
        result.append("  sessionId = ").append(this.sessionId).append("\n");
        result.append("  userPrincipalId = ").append(this.userPrincipalId).append("\n");
        result.append("  url = ").append(this.url).append("\n");
        result.append("  dataCollectorFilter = ");
        if (this.dataCollectorFilter != null) {
            result.append(this.dataCollectorFilter.toString()).append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  errorIDs =");
        if (this.errorIDs != null) {
            for (long id : this.errorIDs) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  startingRequestId = ").append(this.startingRequestId).append("\n");
        result.append("  endRequestId = ").append(this.endRequestId).append("\n");
        result.append("  errorOccured = ").append(this.errorOccured).append("\n");
        result.append("  diagnosticSnapshot = ").append(this.diagnosticSnapshot).append("\n");
        result.append("  badRequest = ").append(this.badRequest).append("\n");
        result.append("  diagnosticSessionGuid =");
        if (this.diagnosticSessionGuid != null) {
            for (String guid : this.diagnosticSessionGuid) {
                result.append("\t").append(guid);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  reqIds =");
        if (this.reqIds != null) {
            for (long id : this.reqIds) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append("  sepIds =");
        if (this.sepIds != null) {
            for (long id : this.sepIds) {
                result.append("\t").append(id);
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        if (this.serverCursor != null) {
            result.append(" serverCursor = ").append(this.serverCursor.toString()).append("\n");
        }
        result.append("  forceV1Search = ").append(this.forceV1Search);
        return result.toString();
    }

    public static RequestSegmentDataFilter getFilterForClientGUID(String clientGUID, long[] applicationIds, TimeRangeSpecifier timeRangeSpecifier, boolean isExtraEUMGuidPropertyReadEnabled) {
        RequestSegmentDataFilter requestSegmentDataFilter = null;
        if (isExtraEUMGuidPropertyReadEnabled) {
            String key = "EUM Request GUID_" + clientGUID;
            requestSegmentDataFilter = RequestSegmentDataFilter.getFilterForTransactionProperty(key, applicationIds, timeRangeSpecifier);
        } else {
            requestSegmentDataFilter = RequestSegmentDataFilter.getFilterForTransactionProperty("EUM Request GUID", clientGUID, applicationIds, timeRangeSpecifier);
        }
        return requestSegmentDataFilter;
    }

    public static RequestSegmentDataFilter getFilterForParentGUID(String parentGUID, long applicationId, TimeRangeSpecifier timeRangeSpecifier) {
        return RequestSegmentDataFilter.getFilterForTransactionProperty("Parent Snapshot GUID", parentGUID, new long[]{applicationId}, timeRangeSpecifier);
    }

    public static RequestSegmentDataFilter getFilterForTransactionProperty(String key, String value, long[] applicationIds, TimeRangeSpecifier timeRangeSpecifier) {
        if (value == null || value.length() == 0) {
            return null;
        }
        RequestSegmentDataFilter filter = new RequestSegmentDataFilter();
        filter.setRangeSpecifier(timeRangeSpecifier);
        filter.setApplicationIds(applicationIds);
        RSDDataCollectorFilter dataCollectorFilter = new RSDDataCollectorFilter();
        dataCollectorFilter.setCollectorType("Transaction Property");
        NameValuePair query = new NameValuePair();
        query.setName(key);
        query.setValue(value);
        dataCollectorFilter.setQuery(query);
        filter.setDataCollectorFilter(dataCollectorFilter);
        return filter;
    }

    public static RequestSegmentDataFilter getFilterForTransactionProperty(String key, long[] applicationIds, TimeRangeSpecifier timeRangeSpecifier) {
        if (key == null || key.length() == 0) {
            return null;
        }
        RequestSegmentDataFilter filter = new RequestSegmentDataFilter();
        filter.setRangeSpecifier(timeRangeSpecifier);
        filter.setApplicationIds(applicationIds);
        RSDDataCollectorFilter dataCollectorFilter = new RSDDataCollectorFilter();
        dataCollectorFilter.setCollectorType("Transaction Property");
        NameValuePair query = new NameValuePair();
        query.setName(key);
        dataCollectorFilter.setQuery(query);
        filter.setDataCollectorFilter(dataCollectorFilter);
        return filter;
    }
}

