/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.TimeRange;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.MachineSnapshotPolicyEventType;
import com.singularity.ee.controller.api.dto.transactionmonitor.MachineSnapshotType;
import java.util.Arrays;

@IgnoreProtoGen
@UiCodeGen
@TSCodeGen(exclude=true)
public class MachineSnapshotFilter
implements SingularitySerializable {
    private long applicationId;
    private long[] machineIds;
    private TimeRangeSpecifier rangeSpecifier;
    private MachineSnapshotType[] snapshotTypes;
    private MachineSnapshotPolicyEventType[] policyEventTypes;
    private long startSnapshotId;
    private long endSnapshotId;
    private boolean archived;
    private int maxRows;

    public MachineSnapshotFilter() {
    }

    public MachineSnapshotFilter(MachineSnapshotFilter filter) {
        int i;
        this.applicationId = filter.getApplicationId();
        if (filter.getMachineIds() != null) {
            this.machineIds = new long[filter.getMachineIds().length];
            for (i = 0; i < filter.getMachineIds().length; ++i) {
                this.machineIds[i] = filter.getMachineIds()[i];
            }
        }
        TimeRangeSpecifier timeRangeSpecifier = this.rangeSpecifier = filter.getRangeSpecifier() == null ? null : filter.getRangeSpecifier().copy();
        if (filter.getSnapshotTypes() != null) {
            this.snapshotTypes = new MachineSnapshotType[filter.getSnapshotTypes().length];
            for (i = 0; i < filter.getSnapshotTypes().length; ++i) {
                this.snapshotTypes[i] = filter.getSnapshotTypes()[i];
            }
        }
        if (filter.getPolicyEventTypes() != null) {
            this.policyEventTypes = new MachineSnapshotPolicyEventType[filter.getPolicyEventTypes().length];
            for (i = 0; i < filter.getPolicyEventTypes().length; ++i) {
                this.policyEventTypes[i] = filter.getPolicyEventTypes()[i];
            }
        }
        this.startSnapshotId = filter.getStartSnapshotId();
        this.endSnapshotId = filter.getEndSnapshotId();
        this.archived = filter.isArchived();
        this.maxRows = filter.getMaxRows();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Machine Snapshot Filter: [").append(" Application id: ").append(this.applicationId).append(", Machine ids: ").append(Arrays.toString(this.machineIds)).append(", TimeRange: ").append(this.rangeSpecifier.toString()).append(", Snapshot Type: ").append(Arrays.toString((Object[])this.snapshotTypes)).append(", Policy Event Type: ").append(Arrays.toString((Object[])this.policyEventTypes)).append(", Archived Only: ").append(this.archived).append(", Max number of results: ").append(this.maxRows).append(" ]");
        return builder.toString();
    }

    public boolean isCacheable(long latestSnapshotTime, long hoursInCache) {
        if (this.hasNonCacheableItems()) {
            return false;
        }
        if (this.rangeSpecifier == null) {
            return false;
        }
        TimeRange range = this.getRangeSpecifier().getTimeRange();
        int startTime = (int)(range.getStartTime().getTime() / 60000L);
        return latestSnapshotTime - (long)startTime <= hoursInCache * 60L;
    }

    public boolean hasNonCacheableItems() {
        if (this.archived) {
            return true;
        }
        return this.snapshotTypes != null && this.snapshotTypes.length > 0;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public long[] getMachineIds() {
        return this.machineIds;
    }

    public void setMachineIds(long[] machineIds) {
        this.machineIds = machineIds;
    }

    public TimeRangeSpecifier getRangeSpecifier() {
        return this.rangeSpecifier;
    }

    public void setRangeSpecifier(TimeRangeSpecifier rangeSpecifier) {
        this.rangeSpecifier = rangeSpecifier;
    }

    public MachineSnapshotType[] getSnapshotTypes() {
        return this.snapshotTypes;
    }

    public void setSnapshotTypes(MachineSnapshotType[] snapshotTypes) {
        this.snapshotTypes = snapshotTypes;
    }

    public MachineSnapshotPolicyEventType[] getPolicyEventTypes() {
        return this.policyEventTypes;
    }

    public void setPolicyEventTypes(MachineSnapshotPolicyEventType[] policyEventTypes) {
        this.policyEventTypes = policyEventTypes;
    }

    public long getStartSnapshotId() {
        return this.startSnapshotId;
    }

    public void setStartSnapshotId(long startSnapshotId) {
        this.startSnapshotId = startSnapshotId;
    }

    public long getEndSnapshotId() {
        return this.endSnapshotId;
    }

    public void setEndSnapshotId(long endSnapshotId) {
        this.endSnapshotId = endSnapshotId;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }
}

