/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.SnapshotPolicy;

@UiCodeGen
@TSCodeGen(exclude=true)
public class DiagnosticSession {
    private String sessionGUID;
    private SnapshotPolicy snapshotPolicy;
    private long startTime;
    private long endTime;
    private String summary;
    private EntityDefinition[] entityDefinition;
    private long internalEventID;
    private volatile int minuteCounter;
    private int durationInMins;
    private int numberPerMin;
    private String[] snapGUIDs;

    public DiagnosticSession() {
        this.endTime = this.startTime = System.currentTimeMillis();
    }

    public DiagnosticSession(int numberPerMin, int durationInMins, String sessionGUID) {
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + (long)(durationInMins * 60 * 1000);
        this.numberPerMin = numberPerMin;
        this.durationInMins = durationInMins;
        this.sessionGUID = sessionGUID;
    }

    public SnapshotPolicy getSnapshotPolicy() {
        return this.snapshotPolicy;
    }

    public void setSnapshotPolicy(SnapshotPolicy snapshotPolicy) {
        this.snapshotPolicy = snapshotPolicy;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getMinuteCounter() {
        return this.minuteCounter;
    }

    public void setMinuteCounter(int minuteCounter) {
        this.minuteCounter = minuteCounter;
    }

    public int incrementAndGetMinuteCounter() {
        if (this.minuteCounter == 0) {
            this.startTime = System.currentTimeMillis();
        }
        return ++this.minuteCounter;
    }

    public int getDurationInMins() {
        return this.durationInMins;
    }

    public void setDurationInMins(int durationInMins) {
        this.durationInMins = durationInMins;
    }

    public int getNumberPerMin() {
        return this.numberPerMin;
    }

    public void setNumberPerMin(int numberPerMin) {
        this.numberPerMin = numberPerMin;
    }

    public EntityDefinition[] getEntityDefinition() {
        return this.entityDefinition;
    }

    public void setEntityDefinition(EntityDefinition[] entityDefinition) {
        this.entityDefinition = entityDefinition;
    }

    public long getInternalEventID() {
        return this.internalEventID;
    }

    public void setInternalEventID(long internalEventID) {
        this.internalEventID = internalEventID;
    }

    public String getSessionGUID() {
        return this.sessionGUID;
    }

    public void setSessionGUID(String sessionGUID) {
        this.sessionGUID = sessionGUID;
    }

    public String[] getSnapGUIDs() {
        return this.snapGUIDs == null ? new String[]{} : this.snapGUIDs;
    }

    public void setSnapGUIDs(String[] snapGUIDs) {
        this.snapGUIDs = snapGUIDs;
    }
}

