/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.serviceendpoint;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.singularity.ee.controller.api.dto.serviceendpoint.ServiceEndpointFilters;
import com.singularity.ee.controller.api.dto.serviceendpoint.ServiceEndpointQueryParams;
import java.util.Objects;

@TSCodeGen(exclude=true)
@UiCodeGen
public class ServiceEndpointRequestFilter {
    private final ServiceEndpointQueryParams queryParams;
    private final ServiceEndpointFilters filters;
    private final String searchText;

    @JsonCreator
    public static ServiceEndpointRequestFilter of(@JsonProperty(value="queryParams") ServiceEndpointQueryParams queryParams, @JsonProperty(value="filters") ServiceEndpointFilters filters, @JsonProperty(value="searchText") String searchText) {
        return new ServiceEndpointRequestFilter(Objects.requireNonNull(queryParams), filters, searchText);
    }

    private ServiceEndpointRequestFilter(ServiceEndpointQueryParams queryParams, ServiceEndpointFilters filters, String searchText) {
        this.queryParams = queryParams;
        this.filters = filters;
        this.searchText = searchText;
    }

    public ServiceEndpointRequestFilter(Builder builder) {
        this(builder.queryParams, builder.filters, builder.searchText);
    }

    public ServiceEndpointQueryParams getQueryParams() {
        return this.queryParams;
    }

    public ServiceEndpointFilters getFilters() {
        return this.filters;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public static class Builder {
        private ServiceEndpointQueryParams queryParams = ServiceEndpointQueryParams.none();
        private ServiceEndpointFilters filters = ServiceEndpointFilters.Builder.builder().build();
        private String searchText = "";

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(ServiceEndpointRequestFilter filter) {
            return new Builder().setQueryParams(filter.getQueryParams()).setFilters(filter.getFilters()).setSearchText(filter.getSearchText());
        }

        public Builder setQueryParams(ServiceEndpointQueryParams queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder setFilters(ServiceEndpointFilters filters) {
            this.filters = filters;
            return this;
        }

        public Builder setSearchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public ServiceEndpointRequestFilter build() {
            return new ServiceEndpointRequestFilter(this);
        }
    }
}

