/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.serviceendpoint;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.serviceendpoint.ServiceEndpointMetric;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceStats;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceValue;

@UiCodeGen
@TSCodeGen(exclude=true)
public class ServiceEndpointMetrics {
    private long serviceEndpointId;
    private ServiceEndpointMetric averageResponseTime;
    private ServiceEndpointMetric callsPerMinute;
    private ServiceEndpointMetric errorsPerMinute;
    private ServiceEndpointMetric numberOfCalls;
    private ServiceEndpointMetric numberOfErrors;

    public static ServiceEndpointMetrics from(long id, PerformanceStats stats) {
        return new ServiceEndpointMetrics(id, ServiceEndpointMetrics.toMetric(stats.getAverageResponseTime()), ServiceEndpointMetrics.toMetric(stats.getCallsPerMinute()), ServiceEndpointMetrics.toMetric(stats.getErrorsPerMinute()), ServiceEndpointMetrics.toMetric(stats.getNumberOfCalls()), ServiceEndpointMetrics.toMetric(stats.getNumberOfErrors()));
    }

    private static ServiceEndpointMetric toMetric(PerformanceValue perfValue) {
        if (perfValue == null) {
            return ServiceEndpointMetric.none();
        }
        return ServiceEndpointMetric.of(perfValue.getMetricId(), perfValue.getMetricValue() != null ? perfValue.getMetricValue().getValue() : 0L);
    }

    private ServiceEndpointMetrics(long id, ServiceEndpointMetric averageResponseTime, ServiceEndpointMetric callsPerMinute, ServiceEndpointMetric errorsPerMinute, ServiceEndpointMetric numberOfCalls, ServiceEndpointMetric numberOfErrors) {
        this.serviceEndpointId = id;
        this.averageResponseTime = averageResponseTime;
        this.callsPerMinute = callsPerMinute;
        this.errorsPerMinute = errorsPerMinute;
        this.numberOfCalls = numberOfCalls;
        this.numberOfErrors = numberOfErrors;
    }

    public long getServiceEndpointId() {
        return this.serviceEndpointId;
    }

    public ServiceEndpointMetric getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public ServiceEndpointMetric getCallsPerMinute() {
        return this.callsPerMinute;
    }

    public ServiceEndpointMetric getErrorsPerMinute() {
        return this.errorsPerMinute;
    }

    public ServiceEndpointMetric getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public ServiceEndpointMetric getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public ServiceEndpointMetrics() {
    }
}

