/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.serviceendpoint;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.serviceendpoint.SEPPerformanceData;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;

@UiCodeGen
@TSCodeGen(exclude=true)
public class ServiceEndpointFilters {
    private final SEPPerformanceData sepPerfData;
    private final List<String> type;
    private final List<String> sepName;
    private final String tierName;
    private final long tierId;

    public ServiceEndpointFilters(Builder builder) {
        this(builder.sepPerfData, builder.type, builder.sepName, builder.tierName, builder.tierId);
    }

    public SEPPerformanceData getSepPerfData() {
        return this.sepPerfData;
    }

    public List<String> getType() {
        return this.type;
    }

    public List<String> getSepName() {
        return this.sepName;
    }

    public String getTierName() {
        return this.tierName;
    }

    public long getTierId() {
        return this.tierId;
    }

    @ConstructorProperties(value={"sepPerfData", "type", "sepName", "tierName", "tierId"})
    public ServiceEndpointFilters(SEPPerformanceData sepPerfData, List<String> type, List<String> sepName, String tierName, long tierId) {
        this.sepPerfData = sepPerfData;
        this.type = type;
        this.sepName = sepName;
        this.tierName = tierName;
        this.tierId = tierId;
    }

    public static class Builder {
        private SEPPerformanceData sepPerfData = SEPPerformanceData.none();
        private List<String> type = new ArrayList<String>();
        private List<String> sepName = new ArrayList<String>();
        private String tierName = "";
        private long tierId = -1L;

        private Builder() {
        }

        public Builder setSEPPerformanceData(SEPPerformanceData sepPerfData) {
            this.sepPerfData = sepPerfData;
            return this;
        }

        public Builder setType(List<String> type) {
            this.type = type;
            return this;
        }

        public Builder setSepName(List<String> sepName) {
            this.sepName = sepName;
            return this;
        }

        public Builder setTierName(String tierName) {
            this.tierName = tierName;
            return this;
        }

        public Builder setTierId(long tierId) {
            this.tierId = tierId;
            return this;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(ServiceEndpointFilters filters) {
            return new Builder().setSepName(filters.getSepName()).setSEPPerformanceData(filters.getSepPerfData()).setTierId(filters.getTierId()).setTierName(filters.getTierName()).setType(filters.getType());
        }

        public ServiceEndpointFilters build() {
            return new ServiceEndpointFilters(this);
        }
    }
}

