/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.preferences.flowView;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.preferences.flowView.FlowViewBackendMember;
import com.singularity.ee.controller.api.dto.preferences.flowView.FlowViewComponentMember;
import com.singularity.ee.controller.api.dto.preferences.flowView.Position3D;

@UiCodeGen
@TSCodeGen(exclude=true)
public class FlowViewMember {
    private Position3D position;
    private String uid;
    private boolean hidden;
    private boolean groupable;

    public static FlowViewMember convertHTMLFlowViewMemberToFlex(FlowViewMember htmlFVM) throws NumberFormatException {
        if (htmlFVM == null || htmlFVM.getUid() == null || htmlFVM.getUid().length() == 0) {
            return new FlowViewMember(htmlFVM);
        }
        String[] tokens = htmlFVM.getUid().split(",");
        if (tokens.length != 2) {
            return new FlowViewMember(htmlFVM);
        }
        String entityTypeString = tokens[0].replace("Type:", "").trim();
        EntityType entityType = EntityType.valueOf((String)entityTypeString);
        if (entityType == null) {
            return new FlowViewMember(htmlFVM);
        }
        String idString = tokens[1].replace("id:", "").trim();
        switch (entityType) {
            case APPLICATION_COMPONENT: {
                FlowViewComponentMember fvcm = new FlowViewComponentMember(htmlFVM);
                long componentId = Long.parseLong(idString);
                fvcm.setComponentId(componentId);
                return fvcm;
            }
            case BACKEND: {
                FlowViewBackendMember fvbm = new FlowViewBackendMember(htmlFVM);
                if (idString.indexOf("_BACKEND_GROUP") != -1) {
                    return null;
                }
                long backendId = Long.parseLong(idString);
                fvbm.setUnresolvedBackendInfoId(backendId);
                return fvbm;
            }
        }
        return new FlowViewMember(htmlFVM);
    }

    public FlowViewMember() {
    }

    public FlowViewMember(String uid, boolean hidden, boolean groupable) {
        this.setUid(uid);
        this.setHidden(hidden);
        this.setGroupable(groupable);
        Position3D pos = new Position3D();
        pos.setX(0.0f);
        pos.setY(0.0f);
        pos.setZ(0.0f);
        this.setPosition(pos);
    }

    public FlowViewMember(String uid) {
        this.setUid(uid);
        Position3D pos = new Position3D();
        pos.setX(0.0f);
        pos.setY(0.0f);
        pos.setZ(0.0f);
        this.setPosition(pos);
    }

    public FlowViewMember(FlowViewMember src) {
        if (src == null) {
            return;
        }
        this.setUid(src.getUid());
        this.setPosition(src.getPosition());
        this.setGroupable(src.isGroupable());
        this.setHidden(src.isHidden());
    }

    public Position3D getPosition() {
        return this.position;
    }

    public void setPosition(Position3D position) {
        this.position = position;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isGroupable() {
        return this.groupable;
    }

    public void setGroupable(boolean groupable) {
        this.groupable = groupable;
    }
}

