/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.policies;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.constants.NodeMatchCriteriaType;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.policies.ComponentMatchCriteria;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.CollectionHelper;

@UiCodeGen
@TSCodeGen(exclude=true)
public class NodeMatchCriteria
extends APersistentObject
implements SingularitySerializable {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_KEY_PREFIX = "nodemc:";
    private static final String CACHE_KEY_NODE_METAINFO_MC_PREFIX = "metaMc:";
    private static final String CACHE_KEY_LATEST_ENV_VARS_PREFIX = "env:";
    private static final String CACHE_KEY_LATEST_VM_SYSTEM_PROP_PREFIX = "vmsp:";
    private static final String CACHE_KEY_TAG_NVM_PROP_PREFIX = "tagnvm:";
    private long[] nodeIds;
    private long[] componentIds;
    private ComponentMatchCriteria componentMatchCriteria;
    private StringMatch nodeNameMatchCriteria;
    private NameValuePair[] nodeMetaInfoMatchCriteria;
    private NameValuePair[] latestVmSystemProperties;
    private NameValuePair[] latestEnvironmentVariables;
    private NameValuePair[] tagNameValues;
    private NodeMatchCriteriaType type;
    private String[] nodeTypes;
    private boolean inverseOnSpecificEntities;

    public NodeMatchCriteriaType getType() {
        return this.type;
    }

    public void setType(NodeMatchCriteriaType type) {
        this.type = type;
    }

    public long[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public long[] getComponentIds() {
        return this.componentIds;
    }

    public void setComponentIds(long[] componentIds) {
        this.componentIds = componentIds;
        this.initComponentMatchCriteriaFromComponentIds();
    }

    public ComponentMatchCriteria getComponentMatchCriteria() {
        if (this.componentMatchCriteria == null) {
            this.initComponentMatchCriteriaFromComponentIds();
        }
        return this.componentMatchCriteria;
    }

    private void initComponentMatchCriteriaFromComponentIds() {
        if (this.componentIds != null && this.componentIds.length > 0) {
            if (this.componentMatchCriteria == null) {
                this.componentMatchCriteria = new ComponentMatchCriteria();
            }
            this.componentMatchCriteria.setComponentIds(this.componentIds);
        }
    }

    public void setComponentMatchCriteria(ComponentMatchCriteria componentMatchCriteria) {
        this.componentMatchCriteria = componentMatchCriteria;
    }

    public StringMatch getNodeNameMatchCriteria() {
        return this.nodeNameMatchCriteria;
    }

    public void setNodeNameMatchCriteria(StringMatch nodeNameMatchCriteria) {
        this.nodeNameMatchCriteria = nodeNameMatchCriteria;
    }

    public NameValuePair[] getNodeMetaInfoMatchCriteria() {
        return this.nodeMetaInfoMatchCriteria;
    }

    public void setNodeMetaInfoMatchCriteria(NameValuePair[] nodeMetaInfoMatchCriteria) {
        this.nodeMetaInfoMatchCriteria = nodeMetaInfoMatchCriteria;
    }

    public NameValuePair[] getLatestVmSystemProperties() {
        return this.latestVmSystemProperties;
    }

    public void setLatestVmSystemProperties(NameValuePair[] latestVmSystemProperties) {
        this.latestVmSystemProperties = latestVmSystemProperties;
    }

    public NameValuePair[] getLatestEnvironmentVariables() {
        return this.latestEnvironmentVariables;
    }

    public void setLatestEnvironmentVariables(NameValuePair[] latestEnvironmentVariables) {
        this.latestEnvironmentVariables = latestEnvironmentVariables;
    }

    public NameValuePair[] getTagNameValues() {
        return this.tagNameValues;
    }

    public void setTagNameValues(NameValuePair[] tagNameValues) {
        this.tagNameValues = tagNameValues;
    }

    public String[] getNodeTypes() {
        return this.nodeTypes;
    }

    public void setNodeTypes(String[] nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public boolean isInverseOnSpecificEntities() {
        return this.inverseOnSpecificEntities;
    }

    public void setInverseOnSpecificEntities(boolean inverseOnSpecificEntities) {
        this.inverseOnSpecificEntities = inverseOnSpecificEntities;
    }

    @JsonIgnore
    public String getCacheKey() {
        StringBuilder builder = new StringBuilder();
        builder.append(CACHE_KEY_PREFIX + (Object)((Object)this.type));
        if (this.nodeIds != null && this.nodeIds.length > 0) {
            builder.append("-");
            builder.append("nodeIds:" + ArrayUtils.arrayFriendlyToString((Object)this.nodeIds));
        }
        if (this.componentIds != null && this.componentIds.length > 0) {
            builder.append("-");
            builder.append("tierIds:" + ArrayUtils.arrayFriendlyToString((Object)this.componentIds));
        }
        if (this.nodeNameMatchCriteria != null) {
            builder.append("-");
            builder.append("sm:");
            builder.append(this.nodeNameMatchCriteria.toString());
        }
        if (this.nodeMetaInfoMatchCriteria != null && this.nodeMetaInfoMatchCriteria.length > 0) {
            builder.append("-metaMc:");
            for (NameValuePair nvp : this.nodeMetaInfoMatchCriteria) {
                builder.append(nvp.toString());
            }
        }
        if (this.latestEnvironmentVariables != null && this.latestEnvironmentVariables.length > 0) {
            builder.append("-env:");
            for (NameValuePair nvp : this.latestEnvironmentVariables) {
                builder.append(nvp.toString());
            }
        }
        if (this.latestVmSystemProperties != null && this.latestVmSystemProperties.length > 0) {
            builder.append("-vmsp:");
            for (NameValuePair nvp : this.latestVmSystemProperties) {
                builder.append(nvp.toString());
            }
        }
        if (this.nodeTypes != null && this.nodeTypes.length > 0) {
            builder.append("-nodeTypes:" + CollectionHelper.arrayToString((Object[])this.nodeTypes));
        }
        if (this.tagNameValues != null && this.tagNameValues.length > 0) {
            builder.append("-tagnvm:");
            for (NameValuePair tagNvp : this.tagNameValues) {
                builder.append(tagNvp.toString());
            }
        }
        return builder.toString();
    }
}

