/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.policies;

import java.util.Objects;

public class MetricInfo {
    private final long metricId;
    private final String metricDisplayName;

    public MetricInfo(long metricId, String metricDisplayName) {
        if (metricId <= 0L) {
            throw new IllegalArgumentException("Metric id should be positive");
        }
        if (metricDisplayName == null) {
            throw new IllegalArgumentException("Metric display name should be provided");
        }
        this.metricId = metricId;
        this.metricDisplayName = metricDisplayName;
    }

    public long getMetricId() {
        return this.metricId;
    }

    public String getMetricDisplayName() {
        return this.metricDisplayName;
    }

    public int hashCode() {
        return Objects.hash(this.metricId, this.metricDisplayName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetricInfo) {
            MetricInfo that = (MetricInfo)obj;
            return this.metricId == that.metricId && this.metricDisplayName.equals(that.metricDisplayName);
        }
        return false;
    }

    public String toString() {
        return "MetricInfo{metricId=" + this.metricId + ", metricDisplayName='" + this.metricDisplayName + '\'' + '}';
    }
}

