/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.policies;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.constants.AbstractMetricDefinitionType;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.policies.AMetricExpression;
import com.singularity.ee.controller.api.dto.policies.AMetricExpressionType;
import com.singularity.ee.controller.api.dto.policies.AbstractMetricDefinition;
import org.apache.commons.lang3.ArrayUtils;

@UiCodeGen
@TSCodeGen(exclude=true)
public class LeafMetricExpression
extends AMetricExpression
implements SingularitySerializable {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_KEY_PREFIX = "lme:";
    private static final String WILDCARD_PREFIX = "*|";
    private static final String WILDCARD_SUFFIX = "|*";
    private boolean literalValueExpression;
    private long literalValue;
    private AbstractMetricDefinition metricDefinition;
    private FunctionType functionType;
    private String displayName;
    private boolean inputMetricText;
    private String inputMetricPath;
    private Long[] extractedAppIdsFromAnalyticsMetric;

    public LeafMetricExpression() {
        this.setType(AMetricExpressionType.LEAF_METRIC_EXPRESSION);
    }

    public LeafMetricExpression(long value) {
        this.setType(AMetricExpressionType.LEAF_METRIC_EXPRESSION);
        this.literalValue = value;
        this.literalValueExpression = true;
    }

    public LeafMetricExpression(AbstractMetricDefinition def, FunctionType function) {
        this.metricDefinition = def;
        this.functionType = function;
        this.literalValueExpression = false;
    }

    public AbstractMetricDefinition getMetricDefinition() {
        return this.metricDefinition;
    }

    public void setMetricDefinition(AbstractMetricDefinition metricDefinition) {
        this.metricDefinition = metricDefinition;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(FunctionType functionType) {
        this.functionType = functionType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public long getValue() {
        return this.literalValue;
    }

    public void setValue(long value) {
        this.literalValue = value;
    }

    public long getLiteralValue() {
        return this.literalValue;
    }

    public void setLiteralValue(long literalValue) {
        this.literalValue = literalValue;
    }

    public boolean isLiteralValueExpression() {
        return this.literalValueExpression;
    }

    public void setLiteralValueExpression(boolean literalValueExpression) {
        this.literalValueExpression = literalValueExpression;
    }

    public boolean isInputMetricText() {
        return this.inputMetricText;
    }

    public void setInputMetricText(boolean inputMetricText) {
        this.inputMetricText = inputMetricText;
    }

    public String getInputMetricPath() {
        return this.inputMetricPath;
    }

    public void setInputMetricPath(String inputMetricPath) {
        this.inputMetricPath = inputMetricPath;
    }

    public Long[] getExtractedAppIdsFromAnalyticsMetric() {
        return this.extractedAppIdsFromAnalyticsMetric;
    }

    public void setExtractedAppIdsFromAnalyticsMetric(Long[] extractedAppIdsFromAnalyticsMetric) {
        this.extractedAppIdsFromAnalyticsMetric = extractedAppIdsFromAnalyticsMetric;
    }

    @Override
    @JsonIgnore
    public String getCacheKey() {
        return "lme::" + this.toString();
    }

    @Override
    public boolean validateMetricDefinitionTypes(AbstractMetricDefinitionType expectedType) {
        boolean result = true;
        if (!this.literalValueExpression) {
            result = this.metricDefinition.getType() == expectedType;
        }
        return result;
    }

    @Override
    public boolean isWildcardExpression() {
        if (this.metricDefinition != null) {
            String logicalMetricName = this.metricDefinition.getLogicalMetricName();
            return logicalMetricName.contains(WILDCARD_SUFFIX) || logicalMetricName.contains(WILDCARD_PREFIX);
        }
        return false;
    }

    public String toString() {
        String extractedAppIdsFromAnalyticsMetricStr = this.extractedAppIdsFromAnalyticsMetric != null ? ArrayUtils.toString((Object)this.extractedAppIdsFromAnalyticsMetric) : null;
        return "LeafMetricExpression{metricDefinition=" + this.metricDefinition + ", functionType=" + this.functionType + ", displayName='" + this.displayName + '\'' + ", literalValue=" + this.literalValue + ", inputMetricText=" + this.inputMetricText + ", inputMetricPath='" + this.inputMetricPath + '\'' + ", literalValueExpression=" + this.literalValueExpression + ", extractedAppIdsFromAnalyticsMetric=" + extractedAppIdsFromAnalyticsMetricStr + '}';
    }
}

