/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.policies;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.constants.AbstractMetricDefinitionType;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.policies.AMetricExpression;
import com.singularity.ee.controller.api.dto.policies.AMetricExpressionType;
import com.singularity.ee.controller.api.dto.policies.MathematicalOperator;

@UiCodeGen
@TSCodeGen(exclude=true)
public class BooleanMetricExpression
extends AMetricExpression
implements SingularitySerializable {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_KEY_OP_PREFIX = "op:";
    private static final String CACHE_KEY_PREFIX = "bme:";
    private AMetricExpression expression1;
    private AMetricExpression expression2;
    private MathematicalOperator operator;

    public BooleanMetricExpression() {
        this.setType(AMetricExpressionType.BOOLEAN_METRIC_EXPRESSION);
    }

    public BooleanMetricExpression(AMetricExpression left, AMetricExpression right, MathematicalOperator op) {
        this.setType(AMetricExpressionType.BOOLEAN_METRIC_EXPRESSION);
        this.expression1 = left;
        this.expression2 = right;
        this.operator = op;
    }

    public AMetricExpression getExpression1() {
        return this.expression1;
    }

    public void setExpression1(AMetricExpression expression1) {
        this.expression1 = expression1;
    }

    public AMetricExpression getExpression2() {
        return this.expression2;
    }

    public void setExpression2(AMetricExpression expression2) {
        this.expression2 = expression2;
    }

    public MathematicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(MathematicalOperator operator) {
        this.operator = operator;
    }

    @Override
    @JsonIgnore
    public String getCacheKey() {
        StringBuilder builder = new StringBuilder();
        builder.append(CACHE_KEY_PREFIX);
        if (this.expression1 != null) {
            builder.append(this.expression1.getCacheKey()).append(",");
        }
        builder.append(CACHE_KEY_OP_PREFIX).append(this.operator).append(",");
        if (this.expression2 != null) {
            builder.append(this.expression2.getCacheKey()).append(",");
        }
        return builder.toString();
    }

    @Override
    public boolean validateMetricDefinitionTypes(AbstractMetricDefinitionType expectedType) {
        return this.expression1.validateMetricDefinitionTypes(expectedType) && this.expression2.validateMetricDefinitionTypes(expectedType);
    }

    @Override
    public boolean isWildcardExpression() {
        return this.expression1.isWildcardExpression() || this.expression2.isWildcardExpression();
    }
}

