/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.pages.nodes;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.ApplicationComponentNode;
import com.singularity.ee.controller.api.dto.CLRMemoryStats;
import com.singularity.ee.controller.api.dto.HardwareStats;
import com.singularity.ee.controller.api.dto.HealthMetricStats;
import com.singularity.ee.controller.api.dto.JVMMemoryStats;
import com.singularity.ee.controller.api.dto.NetworkStats;
import java.util.Date;

@TSCodeGen(exclude=true)
@UiCodeGen
public class AllAppInfraNodeItem {
    private long componentId;
    private String componentName;
    private String componentTypeName;
    private String productType;
    private String productPlatform;
    private String productLanguage;
    private long nodeId;
    private String nodeName;
    private EntityType entityType = EntityType.APPLICATION_COMPONENT_NODE;
    private boolean appServerAgentInstalled;
    private boolean machineAgentInstalled;
    private String appAgentVersion;
    private String jvmVersion;
    private Date appServerRestartDate;
    protected HealthMetricStats healthMetricStats;
    protected HardwareStats hardwareStats;
    protected CLRMemoryStats clrMemoryStats;
    protected JVMMemoryStats jvmMemoryStats;
    protected NetworkStats networkStats;

    public AllAppInfraNodeItem(ApplicationComponentNode node) {
        this.nodeId = node.getId();
        this.nodeName = node.getName();
        this.componentId = node.getComponentId();
        this.componentName = node.getApplicationComponentName();
        this.componentTypeName = node.getComponentType() != null ? node.getComponentType().getName() : "";
        this.appServerAgentInstalled = node.isAppAgentPresent();
        this.machineAgentInstalled = node.isMachineAgentPresent();
        this.productType = node.getComponentType() != null ? node.getComponentType().getProductType() : "";
        this.productPlatform = node.getComponentType() != null ? node.getComponentType().getPlatform() : "";
        String string = this.productLanguage = node.getComponentType() != null ? node.getComponentType().getLanguage() : "default";
        if (node.getAppAgent() != null) {
            this.appAgentVersion = node.getAppAgent().getAgentVersion();
            this.jvmVersion = node.getAppAgent().getLatestAgentRuntime();
            this.appServerRestartDate = node.getAppAgent().getLastStartTime();
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(long componentId) {
        this.componentId = componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentTypeName() {
        return this.componentTypeName;
    }

    public void setComponentTypeName(String componentTypeName) {
        this.componentTypeName = componentTypeName;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getProductPlatform() {
        return this.productPlatform;
    }

    public String getProductLanguage() {
        return this.productLanguage;
    }

    public String getAppAgentVersion() {
        return this.appAgentVersion;
    }

    public void setAppAgentVersion(String appAgentVersion) {
        this.appAgentVersion = appAgentVersion;
    }

    public boolean isMachineAgentInstalled() {
        return this.machineAgentInstalled;
    }

    public void setMachineAgentInstalled(boolean machineAgentInstalled) {
        this.machineAgentInstalled = machineAgentInstalled;
    }

    public boolean isAppServerAgentInstalled() {
        return this.appServerAgentInstalled;
    }

    public void setAppServerAgentInstalled(boolean appServerAgentInstalled) {
        this.appServerAgentInstalled = appServerAgentInstalled;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public void setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public Date getAppServerRestartDate() {
        return this.appServerRestartDate;
    }

    public void setAppServerRestartDate(Date appServerRestartDate) {
        this.appServerRestartDate = appServerRestartDate;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String name) {
        this.nodeName = name;
    }

    public HealthMetricStats getHealthMetricStats() {
        return this.healthMetricStats;
    }

    public void setHealthMetricStats(HealthMetricStats healthMetricStats) {
        this.healthMetricStats = healthMetricStats;
    }

    public HardwareStats getHardwareStats() {
        return this.hardwareStats;
    }

    public void setHardwareStats(HardwareStats hardwareStats) {
        this.hardwareStats = hardwareStats;
    }

    public NetworkStats getNetworkStats() {
        return this.networkStats;
    }

    public void setNetworkStats(NetworkStats networkStats) {
        this.networkStats = networkStats;
    }

    public CLRMemoryStats getClrMemoryStats() {
        return this.clrMemoryStats;
    }

    public void setClrMemoryStats(CLRMemoryStats clrMemoryStats) {
        this.clrMemoryStats = clrMemoryStats;
    }

    public JVMMemoryStats getJvmMemoryStats() {
        return this.jvmMemoryStats;
    }

    public void setJvmMemoryStats(JVMMemoryStats jvmMemoryStats) {
        this.jvmMemoryStats = jvmMemoryStats;
    }
}

