/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.pages.bts;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UiCodeGen
@TSCodeGen(exclude=true)
public class AllBusinessTransactionItem {
    private static final Logger log = LoggerFactory.getLogger(AllBusinessTransactionItem.class);
    private static final MathContext MATH_CONTEXT = new MathContext(1, RoundingMode.HALF_UP);
    private long id;
    private String name;
    private String entryPointType;
    private String applicationComponentName;
    private String performanceState;
    private boolean isOverflowBT;
    private boolean isPerformanceDataAvailable;
    private long componentId;
    private float extremelySlow = -1.0f;
    private float slow = -1.0f;
    private float stalls = -1.0f;
    private float averageBlockTime = -1.0f;
    private float averageCpuUsed = -1.0f;
    private float averageWaitTime = -1.0f;
    private float callsPerMinute = -1.0f;
    private float averageResponseTime = -1.0f;
    private float errorsPerMinute = -1.0f;
    private float numberOfErrors = -1.0f;
    private float numberOfCalls = -1.0f;
    private boolean isGroup;
    private long[] groupMembers;
    private boolean isCollectingOnDemandSnapshots;
    private boolean isAutoDiscovered;
    private boolean isBackground;
    private boolean isPermanent;
    private String originalName;
    private long responseMaxTime = -1L;
    private long responseMinTime = -1L;
    private float endToEndLatencyTime = -1.0f;
    private String detectionRuleId;
    private long createdOn;

    @VisibleForTesting
    AllBusinessTransactionItem(long id, String name, String originalName, long componentId, String applicationComponentName, String entryPointType, String performanceState, boolean isAutoDiscovered, boolean isBackground, boolean isPermanent, boolean isPerformanceDataAvailable, String detectionRuleId, long createdOn) {
        this.id = id;
        this.name = name;
        this.originalName = originalName;
        this.componentId = componentId;
        this.applicationComponentName = applicationComponentName;
        this.entryPointType = entryPointType;
        this.performanceState = performanceState;
        this.isAutoDiscovered = isAutoDiscovered;
        this.isBackground = isBackground;
        this.isPermanent = isPermanent;
        this.isPerformanceDataAvailable = isPerformanceDataAvailable;
        this.detectionRuleId = detectionRuleId;
        this.createdOn = createdOn;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getCallsPerMinute() {
        return this.callsPerMinute;
    }

    public void setCallsPerMinute(float callsPerMinute) {
        this.callsPerMinute = callsPerMinute;
    }

    public float getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public void setAverageResponseTime(float averageResponseTime) {
        this.averageResponseTime = averageResponseTime;
    }

    public float getErrorsPerMinute() {
        return this.errorsPerMinute;
    }

    public void setErrorsPerMinute(float errorsPerMinute) {
        this.errorsPerMinute = errorsPerMinute;
    }

    public float getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(float numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public float getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public void setNumberOfCalls(float numberOfCalls) {
        this.numberOfCalls = numberOfCalls;
    }

    public String getEntryPointType() {
        return this.entryPointType;
    }

    public void setEntryPointType(String entryPointType) {
        this.entryPointType = entryPointType;
    }

    public String getApplicationComponentName() {
        return this.applicationComponentName;
    }

    public void setApplicationComponentName(String applicationComponentName) {
        this.applicationComponentName = applicationComponentName;
    }

    public long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(long componentId) {
        this.componentId = componentId;
    }

    public float getExtremelySlow() {
        return this.extremelySlow;
    }

    public void setExtremelySlow(float extremelySlow) {
        this.extremelySlow = extremelySlow;
    }

    public float getSlow() {
        return this.slow;
    }

    public void setSlow(float slow) {
        this.slow = slow;
    }

    public float getStalls() {
        return this.stalls;
    }

    public void setStalls(float stalls) {
        this.stalls = stalls;
    }

    public float getAverageBlockTime() {
        return this.averageBlockTime;
    }

    public void setAverageBlockTime(float averageBlockTime) {
        this.averageBlockTime = averageBlockTime;
    }

    public float getAverageCpuUsed() {
        return this.averageCpuUsed;
    }

    public void setAverageCpuUsed(float averageCpuUsed) {
        this.averageCpuUsed = averageCpuUsed;
    }

    public float getAverageWaitTime() {
        return this.averageWaitTime;
    }

    public void setAverageWaitTime(float averageWaitTime) {
        this.averageWaitTime = averageWaitTime;
    }

    public String getPerformanceState() {
        return this.performanceState;
    }

    public void setPerformanceState(String performanceState) {
        this.performanceState = performanceState;
    }

    public boolean getIsOverflowBT() {
        return this.isOverflowBT;
    }

    public void setIsOverflowBT(boolean isOverflowBT) {
        this.isOverflowBT = isOverflowBT;
    }

    public boolean getIsPerformanceDataAvailable() {
        return this.isPerformanceDataAvailable;
    }

    public void setIsPerformanceDataAvailable(boolean isPerformanceDataAvailable) {
        this.isPerformanceDataAvailable = isPerformanceDataAvailable;
    }

    public float getErrorPercentage() {
        return this.percentageOfCalls(this.getNumberOfErrors());
    }

    public float getExtremelySlowPercentage() {
        return this.percentageOfCalls(this.getExtremelySlow());
    }

    public float getSlowPercentage() {
        return this.percentageOfCalls(this.getSlow());
    }

    public float getStallsPercentage() {
        return this.percentageOfCalls(this.getStalls());
    }

    private float percentageOfCalls(float numerator) {
        if (numerator <= 0.0f) {
            return 0.0f;
        }
        if (numerator > this.numberOfCalls) {
            log.error("Numerator exceeds number of calls: txnId - %d, numerator - %f, calls - %f", new Object[]{this.id, Float.valueOf(numerator), Float.valueOf(this.numberOfCalls)});
            return 100.0f;
        }
        BigDecimal numeratorWrapper = BigDecimal.valueOf(numerator);
        BigDecimal denominatorWrapper = BigDecimal.valueOf(this.numberOfCalls);
        float result = numeratorWrapper.divide(denominatorWrapper, MATH_CONTEXT).floatValue() * 100.0f;
        return result;
    }

    public void setIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public boolean getIsGroup() {
        return this.isGroup;
    }

    public void setIsCollectingOnDemandSnapshots(boolean isCollectingOnDemandSnapshots) {
        this.isCollectingOnDemandSnapshots = isCollectingOnDemandSnapshots;
    }

    public boolean getIsAutoDiscovered() {
        return this.isAutoDiscovered;
    }

    public void setIsAutoDiscovered(boolean isAutoDiscovered) {
        this.isAutoDiscovered = isAutoDiscovered;
    }

    public boolean getIsCollectingOnDemandSnapshots() {
        return this.isCollectingOnDemandSnapshots;
    }

    public boolean getIsBackground() {
        return this.isBackground;
    }

    public void setIsBackground(boolean isBackground) {
        this.isBackground = isBackground;
    }

    public boolean getIsPermanent() {
        return this.isPermanent;
    }

    public void setIsPermanent(boolean isTransient) {
        this.isPermanent = isTransient;
    }

    public long[] getGroupMembers() {
        return this.groupMembers;
    }

    public void setGroupMembers(long[] groupMembers) {
        this.groupMembers = groupMembers;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public long getResponseMaxTime() {
        return this.responseMaxTime;
    }

    public void setResponseMaxTime(long responseMaxTime) {
        this.responseMaxTime = responseMaxTime;
    }

    public long getResponseMinTime() {
        return this.responseMinTime;
    }

    public void setResponseMinTime(long responseMinTime) {
        this.responseMinTime = responseMinTime;
    }

    public float getEndToEndLatencyTime() {
        return this.endToEndLatencyTime;
    }

    public void setEndToEndLatencyTime(float endToEndLatencyTime) {
        this.endToEndLatencyTime = endToEndLatencyTime;
    }

    public String getDetectionRuleId() {
        return this.detectionRuleId;
    }

    public void setDetectionRuleId(String detectionRuleId) {
        this.detectionRuleId = detectionRuleId;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public static AllBusinessTransactionItemBuilder builder() {
        return new AllBusinessTransactionItemBuilder();
    }

    public String toString() {
        return "AllBusinessTransactionItem(id=" + this.getId() + ", name=" + this.getName() + ", entryPointType=" + this.getEntryPointType() + ", applicationComponentName=" + this.getApplicationComponentName() + ", performanceState=" + this.getPerformanceState() + ", isOverflowBT=" + this.getIsOverflowBT() + ", isPerformanceDataAvailable=" + this.getIsPerformanceDataAvailable() + ", componentId=" + this.getComponentId() + ", extremelySlow=" + this.getExtremelySlow() + ", slow=" + this.getSlow() + ", stalls=" + this.getStalls() + ", averageBlockTime=" + this.getAverageBlockTime() + ", averageCpuUsed=" + this.getAverageCpuUsed() + ", averageWaitTime=" + this.getAverageWaitTime() + ", callsPerMinute=" + this.getCallsPerMinute() + ", averageResponseTime=" + this.getAverageResponseTime() + ", errorsPerMinute=" + this.getErrorsPerMinute() + ", numberOfErrors=" + this.getNumberOfErrors() + ", numberOfCalls=" + this.getNumberOfCalls() + ", isGroup=" + this.getIsGroup() + ", groupMembers=" + Arrays.toString(this.getGroupMembers()) + ", isCollectingOnDemandSnapshots=" + this.getIsCollectingOnDemandSnapshots() + ", isAutoDiscovered=" + this.getIsAutoDiscovered() + ", isBackground=" + this.getIsBackground() + ", isPermanent=" + this.getIsPermanent() + ", originalName=" + this.getOriginalName() + ", responseMaxTime=" + this.getResponseMaxTime() + ", responseMinTime=" + this.getResponseMinTime() + ", endToEndLatencyTime=" + this.getEndToEndLatencyTime() + ", detectionRuleId=" + this.getDetectionRuleId() + ", createdOn=" + this.getCreatedOn() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllBusinessTransactionItem)) {
            return false;
        }
        AllBusinessTransactionItem other = (AllBusinessTransactionItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIsOverflowBT() != other.getIsOverflowBT()) {
            return false;
        }
        if (this.getIsPerformanceDataAvailable() != other.getIsPerformanceDataAvailable()) {
            return false;
        }
        if (this.getComponentId() != other.getComponentId()) {
            return false;
        }
        if (Float.compare(this.getExtremelySlow(), other.getExtremelySlow()) != 0) {
            return false;
        }
        if (Float.compare(this.getSlow(), other.getSlow()) != 0) {
            return false;
        }
        if (Float.compare(this.getStalls(), other.getStalls()) != 0) {
            return false;
        }
        if (Float.compare(this.getAverageBlockTime(), other.getAverageBlockTime()) != 0) {
            return false;
        }
        if (Float.compare(this.getAverageCpuUsed(), other.getAverageCpuUsed()) != 0) {
            return false;
        }
        if (Float.compare(this.getAverageWaitTime(), other.getAverageWaitTime()) != 0) {
            return false;
        }
        if (Float.compare(this.getCallsPerMinute(), other.getCallsPerMinute()) != 0) {
            return false;
        }
        if (Float.compare(this.getAverageResponseTime(), other.getAverageResponseTime()) != 0) {
            return false;
        }
        if (Float.compare(this.getErrorsPerMinute(), other.getErrorsPerMinute()) != 0) {
            return false;
        }
        if (Float.compare(this.getNumberOfErrors(), other.getNumberOfErrors()) != 0) {
            return false;
        }
        if (Float.compare(this.getNumberOfCalls(), other.getNumberOfCalls()) != 0) {
            return false;
        }
        if (this.getIsGroup() != other.getIsGroup()) {
            return false;
        }
        if (this.getIsCollectingOnDemandSnapshots() != other.getIsCollectingOnDemandSnapshots()) {
            return false;
        }
        if (this.getIsAutoDiscovered() != other.getIsAutoDiscovered()) {
            return false;
        }
        if (this.getIsBackground() != other.getIsBackground()) {
            return false;
        }
        if (this.getIsPermanent() != other.getIsPermanent()) {
            return false;
        }
        if (this.getResponseMaxTime() != other.getResponseMaxTime()) {
            return false;
        }
        if (this.getResponseMinTime() != other.getResponseMinTime()) {
            return false;
        }
        if (Float.compare(this.getEndToEndLatencyTime(), other.getEndToEndLatencyTime()) != 0) {
            return false;
        }
        if (this.getCreatedOn() != other.getCreatedOn()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$entryPointType = this.getEntryPointType();
        String other$entryPointType = other.getEntryPointType();
        if (this$entryPointType == null ? other$entryPointType != null : !this$entryPointType.equals(other$entryPointType)) {
            return false;
        }
        String this$applicationComponentName = this.getApplicationComponentName();
        String other$applicationComponentName = other.getApplicationComponentName();
        if (this$applicationComponentName == null ? other$applicationComponentName != null : !this$applicationComponentName.equals(other$applicationComponentName)) {
            return false;
        }
        String this$performanceState = this.getPerformanceState();
        String other$performanceState = other.getPerformanceState();
        if (this$performanceState == null ? other$performanceState != null : !this$performanceState.equals(other$performanceState)) {
            return false;
        }
        if (!Arrays.equals(this.getGroupMembers(), other.getGroupMembers())) {
            return false;
        }
        String this$originalName = this.getOriginalName();
        String other$originalName = other.getOriginalName();
        if (this$originalName == null ? other$originalName != null : !this$originalName.equals(other$originalName)) {
            return false;
        }
        String this$detectionRuleId = this.getDetectionRuleId();
        String other$detectionRuleId = other.getDetectionRuleId();
        return !(this$detectionRuleId == null ? other$detectionRuleId != null : !this$detectionRuleId.equals(other$detectionRuleId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AllBusinessTransactionItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.getIsOverflowBT() ? 79 : 97);
        result = result * 59 + (this.getIsPerformanceDataAvailable() ? 79 : 97);
        long $componentId = this.getComponentId();
        result = result * 59 + (int)($componentId >>> 32 ^ $componentId);
        result = result * 59 + Float.floatToIntBits(this.getExtremelySlow());
        result = result * 59 + Float.floatToIntBits(this.getSlow());
        result = result * 59 + Float.floatToIntBits(this.getStalls());
        result = result * 59 + Float.floatToIntBits(this.getAverageBlockTime());
        result = result * 59 + Float.floatToIntBits(this.getAverageCpuUsed());
        result = result * 59 + Float.floatToIntBits(this.getAverageWaitTime());
        result = result * 59 + Float.floatToIntBits(this.getCallsPerMinute());
        result = result * 59 + Float.floatToIntBits(this.getAverageResponseTime());
        result = result * 59 + Float.floatToIntBits(this.getErrorsPerMinute());
        result = result * 59 + Float.floatToIntBits(this.getNumberOfErrors());
        result = result * 59 + Float.floatToIntBits(this.getNumberOfCalls());
        result = result * 59 + (this.getIsGroup() ? 79 : 97);
        result = result * 59 + (this.getIsCollectingOnDemandSnapshots() ? 79 : 97);
        result = result * 59 + (this.getIsAutoDiscovered() ? 79 : 97);
        result = result * 59 + (this.getIsBackground() ? 79 : 97);
        result = result * 59 + (this.getIsPermanent() ? 79 : 97);
        long $responseMaxTime = this.getResponseMaxTime();
        result = result * 59 + (int)($responseMaxTime >>> 32 ^ $responseMaxTime);
        long $responseMinTime = this.getResponseMinTime();
        result = result * 59 + (int)($responseMinTime >>> 32 ^ $responseMinTime);
        result = result * 59 + Float.floatToIntBits(this.getEndToEndLatencyTime());
        long $createdOn = this.getCreatedOn();
        result = result * 59 + (int)($createdOn >>> 32 ^ $createdOn);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $entryPointType = this.getEntryPointType();
        result = result * 59 + ($entryPointType == null ? 43 : $entryPointType.hashCode());
        String $applicationComponentName = this.getApplicationComponentName();
        result = result * 59 + ($applicationComponentName == null ? 43 : $applicationComponentName.hashCode());
        String $performanceState = this.getPerformanceState();
        result = result * 59 + ($performanceState == null ? 43 : $performanceState.hashCode());
        result = result * 59 + Arrays.hashCode(this.getGroupMembers());
        String $originalName = this.getOriginalName();
        result = result * 59 + ($originalName == null ? 43 : $originalName.hashCode());
        String $detectionRuleId = this.getDetectionRuleId();
        result = result * 59 + ($detectionRuleId == null ? 43 : $detectionRuleId.hashCode());
        return result;
    }

    public AllBusinessTransactionItem() {
    }

    public static class AllBusinessTransactionItemBuilder {
        private long id;
        private String name;
        private String originalName;
        private long componentId;
        private String applicationComponentName;
        private String entryPointType;
        private String performanceState;
        private boolean isAutoDiscovered;
        private boolean isBackground;
        private boolean isPermanent;
        private boolean isPerformanceDataAvailable;
        private String detectionRuleId;
        private long createdOn;

        AllBusinessTransactionItemBuilder() {
        }

        public AllBusinessTransactionItemBuilder id(long id) {
            this.id = id;
            return this;
        }

        public AllBusinessTransactionItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AllBusinessTransactionItemBuilder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public AllBusinessTransactionItemBuilder componentId(long componentId) {
            this.componentId = componentId;
            return this;
        }

        public AllBusinessTransactionItemBuilder applicationComponentName(String applicationComponentName) {
            this.applicationComponentName = applicationComponentName;
            return this;
        }

        public AllBusinessTransactionItemBuilder entryPointType(String entryPointType) {
            this.entryPointType = entryPointType;
            return this;
        }

        public AllBusinessTransactionItemBuilder performanceState(String performanceState) {
            this.performanceState = performanceState;
            return this;
        }

        public AllBusinessTransactionItemBuilder isAutoDiscovered(boolean isAutoDiscovered) {
            this.isAutoDiscovered = isAutoDiscovered;
            return this;
        }

        public AllBusinessTransactionItemBuilder isBackground(boolean isBackground) {
            this.isBackground = isBackground;
            return this;
        }

        public AllBusinessTransactionItemBuilder isPermanent(boolean isPermanent) {
            this.isPermanent = isPermanent;
            return this;
        }

        public AllBusinessTransactionItemBuilder isPerformanceDataAvailable(boolean isPerformanceDataAvailable) {
            this.isPerformanceDataAvailable = isPerformanceDataAvailable;
            return this;
        }

        public AllBusinessTransactionItemBuilder detectionRuleId(String detectionRuleId) {
            this.detectionRuleId = detectionRuleId;
            return this;
        }

        public AllBusinessTransactionItemBuilder createdOn(long createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public AllBusinessTransactionItem build() {
            return new AllBusinessTransactionItem(this.id, this.name, this.originalName, this.componentId, this.applicationComponentName, this.entryPointType, this.performanceState, this.isAutoDiscovered, this.isBackground, this.isPermanent, this.isPerformanceDataAvailable, this.detectionRuleId, this.createdOn);
        }

        public String toString() {
            return "AllBusinessTransactionItem.AllBusinessTransactionItemBuilder(id=" + this.id + ", name=" + this.name + ", originalName=" + this.originalName + ", componentId=" + this.componentId + ", applicationComponentName=" + this.applicationComponentName + ", entryPointType=" + this.entryPointType + ", performanceState=" + this.performanceState + ", isAutoDiscovered=" + this.isAutoDiscovered + ", isBackground=" + this.isBackground + ", isPermanent=" + this.isPermanent + ", isPerformanceDataAvailable=" + this.isPerformanceDataAvailable + ", detectionRuleId=" + this.detectionRuleId + ", createdOn=" + this.createdOn + ")";
        }
    }
}

