/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.fleetmanagement.configs;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.singularity.ee.controller.api.constants.fleetmanagement.FmSupportedAgentType;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;

@TSCodeGen(exclude=true)
@UiCodeGen
public class DeploymentConfigs {
    private String javaDeploymentConfig;
    private String dotNetDeploymentConfig;
    private String nodeJsDeploymentConfig;
    private String pythonDeploymentConfig;
    private String phpDeploymentConfig;
    private String apacheDeploymentConfig;

    public Map<FmSupportedAgentType, String> getSupportedAgentMap() {
        HashMap<FmSupportedAgentType, String> deploymentConfigs = new HashMap<FmSupportedAgentType, String>();
        deploymentConfigs.put(FmSupportedAgentType.APP_AGENT, this.javaDeploymentConfig);
        deploymentConfigs.put(FmSupportedAgentType.DOT_NET_APP_AGENT, this.dotNetDeploymentConfig);
        deploymentConfigs.put(FmSupportedAgentType.NODEJS_APP_AGENT, this.nodeJsDeploymentConfig);
        deploymentConfigs.put(FmSupportedAgentType.PYTHON_APP_AGENT, this.pythonDeploymentConfig);
        deploymentConfigs.put(FmSupportedAgentType.PHP_APP_AGENT, this.phpDeploymentConfig);
        deploymentConfigs.put(FmSupportedAgentType.NATIVE_WEB_SERVER, this.apacheDeploymentConfig);
        return deploymentConfigs;
    }

    public String toJsonString() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString(this.getSupportedAgentMap());
    }

    public static DeploymentConfigs fromJsonString(String jsonString) throws JsonProcessingException {
        Map deploymentConfigs = (Map)new ObjectMapper().readValue(jsonString, Map.class);
        DeploymentConfigs configs = new DeploymentConfigs();
        configs.setJavaDeploymentConfig((String)deploymentConfigs.get(FmSupportedAgentType.APP_AGENT.name()));
        configs.setDotNetDeploymentConfig((String)deploymentConfigs.get(FmSupportedAgentType.DOT_NET_APP_AGENT.name()));
        configs.setNodeJsDeploymentConfig((String)deploymentConfigs.get(FmSupportedAgentType.NODEJS_APP_AGENT.name()));
        configs.setPythonDeploymentConfig((String)deploymentConfigs.get(FmSupportedAgentType.PYTHON_APP_AGENT.name()));
        configs.setPhpDeploymentConfig((String)deploymentConfigs.get(FmSupportedAgentType.PHP_APP_AGENT.name()));
        configs.setApacheDeploymentConfig((String)deploymentConfigs.get(FmSupportedAgentType.NATIVE_WEB_SERVER.name()));
        return configs;
    }

    public JsonObject getConfig(FmSupportedAgentType agentType) {
        String configStr = this.getSupportedAgentMap().get(agentType);
        if (configStr == null) {
            return null;
        }
        return Json.createReader((Reader)new StringReader(configStr)).readObject();
    }

    public String getJavaDeploymentConfig() {
        return this.javaDeploymentConfig;
    }

    public String getDotNetDeploymentConfig() {
        return this.dotNetDeploymentConfig;
    }

    public String getNodeJsDeploymentConfig() {
        return this.nodeJsDeploymentConfig;
    }

    public String getPythonDeploymentConfig() {
        return this.pythonDeploymentConfig;
    }

    public String getPhpDeploymentConfig() {
        return this.phpDeploymentConfig;
    }

    public String getApacheDeploymentConfig() {
        return this.apacheDeploymentConfig;
    }

    public void setJavaDeploymentConfig(String javaDeploymentConfig) {
        this.javaDeploymentConfig = javaDeploymentConfig;
    }

    public void setDotNetDeploymentConfig(String dotNetDeploymentConfig) {
        this.dotNetDeploymentConfig = dotNetDeploymentConfig;
    }

    public void setNodeJsDeploymentConfig(String nodeJsDeploymentConfig) {
        this.nodeJsDeploymentConfig = nodeJsDeploymentConfig;
    }

    public void setPythonDeploymentConfig(String pythonDeploymentConfig) {
        this.pythonDeploymentConfig = pythonDeploymentConfig;
    }

    public void setPhpDeploymentConfig(String phpDeploymentConfig) {
        this.phpDeploymentConfig = phpDeploymentConfig;
    }

    public void setApacheDeploymentConfig(String apacheDeploymentConfig) {
        this.apacheDeploymentConfig = apacheDeploymentConfig;
    }
}

