/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.fleetmanagement;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.fleetmanagement.configs.AutoAttachConfig;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

@UiCodeGen
@TSCodeGen(exclude=true)
public class SmartAgentAutoAttachConfig
extends APersistentObject {
    private String configJson;
    private String configHash;

    public void setConfigJson(AutoAttachConfig config) throws IllegalArgumentException {
        try {
            this.configJson = config.toJsonString();
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to convert auto attach config to json", e);
        }
        this.setConfigJson(this.configJson);
    }

    public void setConfigJson(String configJson) {
        this.configJson = configJson;
        try {
            this.configHash = new String(MessageDigest.getInstance("SHA1").digest(this.configJson.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to calculate hash for auto attach config", e);
        }
    }

    public String getConfigJson() {
        return this.configJson;
    }

    public String getConfigHash() {
        return this.configHash;
    }
}

