/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.federation;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.google.common.base.Strings;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.ExitCallMetricTreeItem;
import com.singularity.ee.controller.api.dto.federation.FederatedTransactionFlowItemIdentifier;
import com.singularity.ee.controller.api.dto.federation.IFederatedMetricTreeItem;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionExitPointCall;
import com.singularity.ee.controller.api.exceptions.FederatedMetricTreeItemNameChangeException;

@UiCodeGen
@TSCodeGen(exclude=true)
public class FederatedIncomingCallMetricTreeItem
extends ExitCallMetricTreeItem
implements IFederatedMetricTreeItem {
    private static final String EXITCALL_TREE_ITEM_NAME_SPLITTER = " ";
    private long federatedAccountRegisteredEntityId;

    public FederatedIncomingCallMetricTreeItem(TransactionExitPointCall exitCall, FederatedTransactionFlowItemIdentifier identifier, long federatedAccountRegisteredEntityId) {
        super(exitCall, identifier);
        this.federatedAccountRegisteredEntityId = federatedAccountRegisteredEntityId;
    }

    public FederatedIncomingCallMetricTreeItem() {
    }

    protected void shallowCopy(FederatedIncomingCallMetricTreeItem copy) {
        super.shallowCopy(copy);
        copy.setFederatedAccountRegisteredEntityId(this.federatedAccountRegisteredEntityId);
    }

    @Override
    public FederatedIncomingCallMetricTreeItem shallowCopy() {
        FederatedIncomingCallMetricTreeItem copy = new FederatedIncomingCallMetricTreeItem();
        this.shallowCopy(copy);
        return copy;
    }

    public long getFederatedAccountRegisteredEntityId() {
        return this.federatedAccountRegisteredEntityId;
    }

    public void setFederatedAccountRegisteredEntityId(long federatedAccountRegisteredEntityId) {
        this.federatedAccountRegisteredEntityId = federatedAccountRegisteredEntityId;
    }

    @Override
    public void patchNewEntityName(EntityType entityType, String newEntityName) {
        if (Strings.isNullOrEmpty((String)newEntityName)) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Invalid new name: " + newEntityName + " Existing Name: " + this.getName() + " Modify entity type: " + entityType.name());
        }
        if (entityType != EntityType.FEDERATED_COMPONENT) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Unsupported entity type: " + entityType.name());
        }
        try {
            String nodeName = this.getName();
            String[] split = nodeName.split(EXITCALL_TREE_ITEM_NAME_SPLITTER);
            int tierIndex = nodeName.length() - split[split.length - 1].length();
            String newNodeName = nodeName.substring(0, tierIndex) + newEntityName;
            this.setName(newNodeName);
        }
        catch (RuntimeException x) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Existing Name: " + this.getName() + " Modify entity type: " + entityType.name() + " New Name: " + newEntityName + " Error detail: " + x.getMessage());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FederatedIncomingCallMetricTreeItem that = (FederatedIncomingCallMetricTreeItem)o;
        return this.federatedAccountRegisteredEntityId == that.federatedAccountRegisteredEntityId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.federatedAccountRegisteredEntityId ^ this.federatedAccountRegisteredEntityId >>> 32);
        return result;
    }

    @Override
    public EntityDefinition[] getEntityDefinitions() {
        return new EntityDefinition[]{new EntityDefinition(EntityType.FEDERATED_ACCOUNT, this.getFederatedAccountRegisteredEntityId()), this.getIdentifier().getEntityDefinition()};
    }
}

