/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.federation;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.google.common.base.Strings;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.ExitCallMetricTreeItem;
import com.singularity.ee.controller.api.dto.federation.FederatedTransactionFlowItemIdentifier;
import com.singularity.ee.controller.api.dto.federation.IFederatedMetricTreeItem;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionExitPointCall;
import com.singularity.ee.controller.api.exceptions.FederatedMetricTreeItemNameChangeException;

@UiCodeGen
@TSCodeGen(exclude=true)
public class FederatedExitCallMetricTreeItem
extends ExitCallMetricTreeItem
implements IFederatedMetricTreeItem {
    private static final String FEDERATED_APPNAME_AND_ACCOUNTNAME_SEPERATOR = "@";
    private static final String EXITCALL_TREE_ITEM_NAME_SPLITTER = " ";
    private long federatedAccountRegisteredEntityId;

    public FederatedExitCallMetricTreeItem(TransactionExitPointCall exitCall, FederatedTransactionFlowItemIdentifier identifier, long federatedAccountRegisteredEntityId) {
        super(exitCall, identifier);
        this.federatedAccountRegisteredEntityId = federatedAccountRegisteredEntityId;
    }

    public FederatedExitCallMetricTreeItem() {
    }

    protected void shallowCopy(FederatedExitCallMetricTreeItem copy) {
        super.shallowCopy(copy);
        copy.setFederatedAccountRegisteredEntityId(this.federatedAccountRegisteredEntityId);
    }

    @Override
    public FederatedExitCallMetricTreeItem shallowCopy() {
        FederatedExitCallMetricTreeItem copy = new FederatedExitCallMetricTreeItem();
        this.shallowCopy(copy);
        return copy;
    }

    public long getFederatedAccountRegisteredEntityId() {
        return this.federatedAccountRegisteredEntityId;
    }

    public void setFederatedAccountRegisteredEntityId(long federatedAccountRegisteredEntityId) {
        this.federatedAccountRegisteredEntityId = federatedAccountRegisteredEntityId;
    }

    @Override
    public void patchNewEntityName(EntityType entityType, String newEntityName) {
        if (Strings.isNullOrEmpty((String)newEntityName)) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Invalid new name: " + newEntityName + " Existing Name: " + this.getName() + " Modify entity type: " + entityType.name());
        }
        try {
            String nodeName = this.getName();
            String[] split = nodeName.split(EXITCALL_TREE_ITEM_NAME_SPLITTER);
            int accountAppIndex = split.length - 1;
            int indexOfAccount = nodeName.lastIndexOf(FEDERATED_APPNAME_AND_ACCOUNTNAME_SEPERATOR) + 1;
            int indexOfApplicationName = nodeName.length() - split[accountAppIndex].length();
            String accountName = nodeName.substring(indexOfAccount);
            String appName = nodeName.substring(indexOfApplicationName, indexOfAccount - 1);
            switch (entityType) {
                case FEDERATED_ACCOUNT: {
                    accountName = newEntityName;
                    break;
                }
                case FEDERATED_APPLICATION: {
                    appName = newEntityName;
                    break;
                }
                default: {
                    throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Unsupported entity type: " + entityType.name());
                }
            }
            String appAccountName = appName + FEDERATED_APPNAME_AND_ACCOUNTNAME_SEPERATOR + accountName;
            String newNodeName = nodeName.substring(0, indexOfApplicationName) + appAccountName;
            this.setName(newNodeName);
        }
        catch (FederatedMetricTreeItemNameChangeException federatedMetricTreeException) {
            throw federatedMetricTreeException;
        }
        catch (RuntimeException x) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Existing Name: " + this.getName() + " Modify entity type: " + entityType.name() + " New Name: " + newEntityName + " Error detail: " + x.getMessage());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FederatedExitCallMetricTreeItem that = (FederatedExitCallMetricTreeItem)o;
        return this.federatedAccountRegisteredEntityId == that.federatedAccountRegisteredEntityId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.federatedAccountRegisteredEntityId ^ this.federatedAccountRegisteredEntityId >>> 32);
        return result;
    }

    @Override
    public EntityDefinition[] getEntityDefinitions() {
        return new EntityDefinition[]{new EntityDefinition(EntityType.FEDERATED_ACCOUNT, this.getFederatedAccountRegisteredEntityId()), this.getIdentifier().getEntityDefinition()};
    }
}

