/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.federation;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.google.common.base.Strings;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.ApplicationMetricTreeItem;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.federation.IFederatedMetricTreeItem;
import com.singularity.ee.controller.api.exceptions.FederatedMetricTreeItemNameChangeException;

@UiCodeGen
@TSCodeGen(exclude=true)
public class FederatedApplicationMetricTreeItem
extends ApplicationMetricTreeItem
implements IFederatedMetricTreeItem {
    private static final String FEDERATED_APPNAME_AND_ACCOUNTNAME_SEPARATOR = "@";
    private long federatedAccountRegisteredEntityId;

    public FederatedApplicationMetricTreeItem(long federatedAccountRegisteredEntityId, long appId) {
        super(appId);
        this.federatedAccountRegisteredEntityId = federatedAccountRegisteredEntityId;
    }

    public FederatedApplicationMetricTreeItem() {
    }

    protected void shallowCopy(FederatedApplicationMetricTreeItem copy) {
        super.shallowCopy(copy);
        copy.setFederatedAccountRegisteredEntityId(this.federatedAccountRegisteredEntityId);
    }

    @Override
    public FederatedApplicationMetricTreeItem shallowCopy() {
        FederatedApplicationMetricTreeItem copy = new FederatedApplicationMetricTreeItem();
        this.shallowCopy(copy);
        return copy;
    }

    public long getFederatedAccountRegisteredEntityId() {
        return this.federatedAccountRegisteredEntityId;
    }

    public void setFederatedAccountRegisteredEntityId(long federatedAccountRegisteredEntityId) {
        this.federatedAccountRegisteredEntityId = federatedAccountRegisteredEntityId;
    }

    @Override
    public void patchNewEntityName(EntityType entityType, String newEntityName) {
        if (Strings.isNullOrEmpty((String)newEntityName)) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Invalid new name: " + newEntityName + " Existing Name: " + this.getName() + " Modify entity type: " + entityType.name());
        }
        try {
            String nodeName = this.getName();
            String[] split = nodeName.split(FEDERATED_APPNAME_AND_ACCOUNTNAME_SEPARATOR);
            String appName = split[0];
            String accountName = split[1];
            switch (entityType) {
                case FEDERATED_ACCOUNT: {
                    accountName = newEntityName;
                    break;
                }
                case FEDERATED_APPLICATION: {
                    appName = newEntityName;
                    break;
                }
                default: {
                    throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Unsupported entity type: " + entityType.name());
                }
            }
            String appAccountName = appName + FEDERATED_APPNAME_AND_ACCOUNTNAME_SEPARATOR + accountName;
            this.setName(appAccountName);
        }
        catch (FederatedMetricTreeItemNameChangeException federatedMetricTreeException) {
            throw federatedMetricTreeException;
        }
        catch (RuntimeException x) {
            throw new FederatedMetricTreeItemNameChangeException("Failed to patch federated metric tree item - Existing Name: " + this.getName() + " Modify entity type: " + entityType.name() + " New Name: " + newEntityName + " Error detail: " + x.getMessage());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FederatedApplicationMetricTreeItem that = (FederatedApplicationMetricTreeItem)o;
        return this.federatedAccountRegisteredEntityId == that.federatedAccountRegisteredEntityId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.federatedAccountRegisteredEntityId ^ this.federatedAccountRegisteredEntityId >>> 32);
        return result;
    }

    @Override
    public EntityDefinition[] getEntityDefinitions() {
        return new EntityDefinition[]{new EntityDefinition(EntityType.FEDERATED_ACCOUNT, this.getFederatedAccountRegisteredEntityId()), new EntityDefinition(EntityType.FEDERATED_APPLICATION, this.getApplicationId())};
    }
}

