/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.customdashboard;

import com.singularity.ee.controller.api.dto.MetricMatchCriteria;
import com.singularity.ee.controller.api.dto.policies.APolicyAffectedEntityMatchCriteria;
import com.singularity.ee.controller.api.dto.policies.APolicyAffectedEntityMatchCriteriaType;

public class WidgetDataUtil {
    private static final String DASH = " - ";
    private static final String ENTITY_TOKEN = "${e}";
    private static final String METRIC_TOKEN = "${m}";
    private static final String NUMBER_TOKEN = "${#}";
    private static final String EXPRESSION_TOKEN = "${me}";

    public static String getMathDisplayName(MetricMatchCriteria mmc, int sequenceId, String entityName, String metricExpression) {
        String displayName;
        if (!WidgetDataUtil.isEmpty(mmc.getMetricDisplayNameCustomFormat())) {
            String formatter = mmc.getMetricDisplayNameCustomFormat();
            formatter = formatter.replace(ENTITY_TOKEN, !WidgetDataUtil.isEmpty(entityName) ? entityName : "");
            formatter = formatter.replace(NUMBER_TOKEN, Integer.toString(sequenceId));
            displayName = formatter = formatter.replace(EXPRESSION_TOKEN, metricExpression);
        } else {
            displayName = !WidgetDataUtil.isEmpty(entityName) ? entityName + DASH + metricExpression : metricExpression;
        }
        return displayName;
    }

    public static String getMetricDisplayName(String legendFormat, int sequenceId, String entityName, String logicalMetricName) {
        String metricNameEnd = logicalMetricName;
        if (entityName != null) {
            metricNameEnd = WidgetDataUtil.getLastNFromFullMetricName(logicalMetricName);
        }
        String metricName = legendFormat;
        metricName = metricName.replace(METRIC_TOKEN, !WidgetDataUtil.isEmpty(metricNameEnd) ? metricNameEnd : "");
        metricName = metricName.replace(ENTITY_TOKEN, !WidgetDataUtil.isEmpty(entityName) ? entityName : "");
        metricName = metricName.replace(NUMBER_TOKEN, Integer.toString(sequenceId));
        return metricName;
    }

    public static String getPrettyName(String entityName, String logicalMetricName, boolean shouldPrependEntityName) {
        String prettyMetricName = null;
        if (entityName != null) {
            String metricNameEnd = WidgetDataUtil.getLastNFromFullMetricName(logicalMetricName);
            prettyMetricName = shouldPrependEntityName && metricNameEnd != null && metricNameEnd.indexOf(entityName) == -1 ? entityName + DASH + metricNameEnd : metricNameEnd;
        }
        return prettyMetricName;
    }

    public static String getLastNFromFullMetricName(String metricFullPath) {
        String[] parts;
        int numCommonPrefixes = 1;
        if (metricFullPath.startsWith("Business Transaction Performance|Business Transactions|")) {
            numCommonPrefixes = 2;
        }
        if (metricFullPath.indexOf("Individual Nodes") > 0) {
            numCommonPrefixes += 2;
        }
        String metricNameEnd = metricFullPath;
        if (metricFullPath != null && (parts = metricFullPath.split("\\|")).length >= numCommonPrefixes) {
            StringBuilder end = new StringBuilder();
            for (int i = numCommonPrefixes; i < parts.length; ++i) {
                if (end.length() > 0) {
                    end.append(" > ");
                }
                end.append(parts[i]);
            }
            return end.toString();
        }
        return metricNameEnd;
    }

    public static boolean shouldPrependEntityName(APolicyAffectedEntityMatchCriteria apaemc) {
        boolean shouldPrependEntityName = apaemc == null || !apaemc.getAemcType().equals((Object)APolicyAffectedEntityMatchCriteriaType.DB_SERVER_AFFECTED_EMC);
        return shouldPrependEntityName;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

