/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.customdashboard;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.controller.api.dto.MetricData;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import com.singularity.ee.controller.api.dto.MetricDefinition;
import com.singularity.ee.controller.api.dto.MetricMatchCriteria;
import com.singularity.ee.controller.api.dto.customdashboard.ASeriesData;
import com.singularity.ee.controller.api.dto.customdashboard.MetricQuery;

@UiCodeGen
@TSCodeGen(exclude=true)
public class GaugeSeriesData
extends ASeriesData {
    private Double value;
    private Long min;
    private Long max;
    private Double baselineValue;
    private Double standardDeviationValue;
    private boolean includeAbove;
    private boolean includeBelow;
    private boolean includeBoth;
    private boolean includeBand12;
    private boolean includeBand23;
    private boolean includeBand34;
    private boolean includeBand45;
    private boolean includeShade;

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getMin() {
        return this.min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public Double getBaselineValue() {
        return this.baselineValue;
    }

    public void setBaselineValue(Double baselineValue) {
        this.baselineValue = baselineValue;
    }

    public Double getStandardDeviationValue() {
        return this.standardDeviationValue;
    }

    public void setStandardDeviationValue(Double standardDeviationValue) {
        this.standardDeviationValue = standardDeviationValue;
    }

    public boolean getIncludeAbove() {
        return this.includeAbove;
    }

    public void setIncludeAbove(boolean includeAbove) {
        this.includeAbove = includeAbove;
    }

    public boolean getIncludeBelow() {
        return this.includeBelow;
    }

    public void setIncludeBelow(boolean includeBelow) {
        this.includeBelow = includeBelow;
    }

    public boolean getIncludeBoth() {
        return this.includeBoth;
    }

    public void setIncludeBoth(boolean includeBoth) {
        this.includeBoth = includeBoth;
    }

    public boolean getIncludeBand12() {
        return this.includeBand12;
    }

    public void setIncludeBand12(boolean includeBand12) {
        this.includeBand12 = includeBand12;
    }

    public boolean getIncludeBand23() {
        return this.includeBand23;
    }

    public void setIncludeBand23(boolean includeBand23) {
        this.includeBand23 = includeBand23;
    }

    public boolean getIncludeBand34() {
        return this.includeBand34;
    }

    public void setIncludeBand34(boolean includeBand34) {
        this.includeBand34 = includeBand34;
    }

    public boolean getIncludeBand45() {
        return this.includeBand45;
    }

    public void setIncludeBand45(boolean includeBand45) {
        this.includeBand45 = includeBand45;
    }

    public boolean getIncludeShade() {
        return this.includeShade;
    }

    public void setIncludeShade(boolean includeShade) {
        this.includeShade = includeShade;
    }

    @Override
    public void populate(MetricQuery metricQuery, String logicalMetricName, MetricDefinition metricDefinition, MetricData metricData, String entityName, FunctionType functionType, long baselineId, boolean seriesUsesMathExpression, int sequenceId) {
        MetricDataTimeslice timeslice;
        this.fillInMetaData(metricQuery, logicalMetricName, metricDefinition, entityName, baselineId, seriesUsesMathExpression, sequenceId);
        MetricDataTimeslice[] dataTimeslices = metricData.getDataTimeslices();
        boolean placeholderSeries = true;
        if (dataTimeslices != null && dataTimeslices.length > 0 && (timeslice = dataTimeslices[0]) != null && timeslice.getMetricValue() != null && timeslice.getMetricValue().getCount() > 0L) {
            this.value = this.getMetricValueDoubleFromTimeslice(timeslice, functionType, seriesUsesMathExpression);
            this.min = timeslice.getMetricValue().getMin();
            this.max = timeslice.getMetricValue().getMax();
            placeholderSeries = false;
            MetricMatchCriteria mmc = metricQuery.getMetricMatchCriteria();
            if (mmc.isUseActiveBaseline() || mmc.getBaselineId() > 0L) {
                this.baselineValue = timeslice.getMetricValue().getValue();
                this.standardDeviationValue = timeslice.getMetricValue().getStandardDeviation();
            }
        }
        super.setPlaceholderSeries(placeholderSeries);
        this.setIncludeAbove(metricQuery.getMetricMatchCriteria().getIncludeAbove());
        this.setIncludeBelow(metricQuery.getMetricMatchCriteria().getIncludeBelow());
        this.setIncludeBoth(metricQuery.getMetricMatchCriteria().getIncludeBoth());
        this.setIncludeBand12(metricQuery.getMetricMatchCriteria().getIncludeBand12());
        this.setIncludeBand23(metricQuery.getMetricMatchCriteria().getIncludeBand23());
        this.setIncludeBand34(metricQuery.getMetricMatchCriteria().getIncludeBand34());
        this.setIncludeBand45(metricQuery.getMetricMatchCriteria().getIncludeBand45());
        this.setIncludeShade(metricQuery.getMetricMatchCriteria().getIncludeShade());
        this.setGranularityInMinutes(metricData.getGranularityMinutes());
    }
}

