/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.customdashboard;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.TimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.customdashboard.ACustomDashboardWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.CustomDashBoardCanvasType;
import com.singularity.ee.controller.api.dto.customdashboard.DashBoardTimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.customdashboard.DashboardGaugeWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.DashboardGraphWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.DashboardPieWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.DashboardStreamingGraphWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.IFrameCustomDashboardWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.ImageDashboardWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.ListWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.LogTailWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.MetricLabelDashboardWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.PolicyStatusDashboardWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.TextDashboardWidgetUIState;
import com.singularity.ee.controller.api.dto.customdashboard.WidgetMetricMatchCriteriaUIState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlTransient;

@UiCodeGen
@TSCodeGen(exclude=true)
public class CustomDashboardUIState
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElementRefs(value={@XmlElementRef(name="TIMESERIES_GRAPH", type=DashboardGraphWidgetUIState.class), @XmlElementRef(name="PIE", type=DashboardPieWidgetUIState.class), @XmlElementRef(name="GAUGE", type=DashboardGaugeWidgetUIState.class), @XmlElementRef(name="IFRAME", type=IFrameCustomDashboardWidgetUIState.class), @XmlElementRef(name="IMAGE", type=ImageDashboardWidgetUIState.class), @XmlElementRef(name="METRIC_LABEL", type=MetricLabelDashboardWidgetUIState.class), @XmlElementRef(name="STATUS_LIGHT", type=PolicyStatusDashboardWidgetUIState.class), @XmlElementRef(name="LABEL", type=TextDashboardWidgetUIState.class), @XmlElementRef(name="LIST", type=ListWidgetUIState.class), @XmlElementRef(name="LOG_TAIL", type=LogTailWidgetUIState.class), @XmlElementRef(name="STREAMING_GRAPH", type=DashboardStreamingGraphWidgetUIState.class)})
    private ACustomDashboardWidgetUIState[] widgets;
    private WidgetMetricMatchCriteriaUIState[] widgetMetricMatchCriteriaUIStates;
    private int refreshInterval;
    private int backgroundColor;
    private int color;
    private int height;
    private int width;
    private String canvasType = CustomDashBoardCanvasType.CANVAS_TYPE_ABSOLUTE.name();
    private DashBoardTimeRangeSpecifierType timeRangeSpecifierType = DashBoardTimeRangeSpecifierType.UNKNOWN;
    private int minutesBeforeAnchorTime;
    private long startTime;
    private long endTime;
    private Boolean isTemplate = false;
    private Boolean isWarRoom = false;
    private EntityType templateEntityType;
    private String layoutType = "";

    @JsonIgnore
    @XmlTransient
    public TimeRangeSpecifier getTimeRangeForDashboard() {
        TimeRangeSpecifier trs = new TimeRangeSpecifier();
        if (this.getMinutesBeforeAnchorTime() == 0) {
            trs.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
            trs.setStartTime(new Date(this.startTime));
            trs.setEndTime(new Date(this.endTime));
            trs.setDurationInMinutes((int)((this.endTime - this.startTime) / 60000L));
        } else {
            trs.setType(TimeRangeSpecifierType.BEFORE_NOW);
            trs.setDurationInMinutes(this.getMinutesBeforeAnchorTime());
        }
        return trs;
    }

    public String getCanvasType() {
        return this.canvasType;
    }

    public void setCanvasType(String canvasType) {
        this.canvasType = canvasType;
    }

    public void setTimeRangeSpecifierType(DashBoardTimeRangeSpecifierType timeRangeSpecifierType) {
        this.timeRangeSpecifierType = timeRangeSpecifierType;
    }

    public DashBoardTimeRangeSpecifierType getTimeRangeSpecifierType() {
        return this.timeRangeSpecifierType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getMinutesBeforeAnchorTime() {
        return this.minutesBeforeAnchorTime;
    }

    public void setMinutesBeforeAnchorTime(int minutesBeforeAnchorTime) {
        this.minutesBeforeAnchorTime = minutesBeforeAnchorTime;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public ACustomDashboardWidgetUIState[] getWidgets() {
        return this.widgets;
    }

    public void setWidgets(ACustomDashboardWidgetUIState ... widgets) {
        this.widgets = widgets;
    }

    public WidgetMetricMatchCriteriaUIState[] getWidgetMetricMatchCriteriaUIStates() {
        return this.widgetMetricMatchCriteriaUIStates;
    }

    public void setWidgetMetricMatchCriteriaUIStates(WidgetMetricMatchCriteriaUIState[] widgetMetricMatchCriteriaUIStates) {
        this.widgetMetricMatchCriteriaUIStates = widgetMetricMatchCriteriaUIStates;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public ACustomDashboardWidgetUIState getWidgetByGuid(String guidToFind) {
        if (this.widgets != null) {
            for (ACustomDashboardWidgetUIState widget : this.widgets) {
                if (!guidToFind.equals(widget.getWidgetGuid())) continue;
                return widget;
            }
        }
        return null;
    }

    public WidgetMetricMatchCriteriaUIState[] getWidgetMetricMatchCriteriaUIStatesByGuid(String guidToFind) {
        ArrayList<WidgetMetricMatchCriteriaUIState> results = new ArrayList<WidgetMetricMatchCriteriaUIState>();
        if (this.widgets != null) {
            for (WidgetMetricMatchCriteriaUIState widgetMMCUIState : this.widgetMetricMatchCriteriaUIStates) {
                if (!guidToFind.equals(widgetMMCUIState.getWidgetGuid())) continue;
                results.add(widgetMMCUIState);
            }
        }
        return results.toArray(new WidgetMetricMatchCriteriaUIState[results.size()]);
    }

    public Boolean getIsTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(Boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public Boolean getIsWarRoom() {
        return this.isWarRoom;
    }

    public void setIsWarRoom(Boolean isWarRoom) {
        this.isWarRoom = isWarRoom;
    }

    public EntityType getTemplateEntityType() {
        return this.templateEntityType;
    }

    public void setTemplateEntityType(EntityType templateEntityType) {
        this.templateEntityType = templateEntityType;
    }

    public String getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(String layoutType) {
        this.layoutType = layoutType;
    }

    public void ensureValidStateAfterDeserializedFromXml() {
        if (null == this.isTemplate) {
            this.isTemplate = false;
        }
        if (null == this.isWarRoom) {
            this.isWarRoom = false;
        }
        if (null == this.canvasType) {
            this.canvasType = CustomDashBoardCanvasType.CANVAS_TYPE_ABSOLUTE.name();
        }
        if (null == this.layoutType) {
            this.layoutType = "";
        }
    }
}

