/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.customdashboard;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.controller.api.dto.MetricData;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import com.singularity.ee.controller.api.dto.MetricDefinition;
import com.singularity.ee.controller.api.dto.MetricMatchCriteria;
import com.singularity.ee.controller.api.dto.customdashboard.MetricQuery;
import com.singularity.ee.controller.api.dto.customdashboard.WidgetDataUtil;

@UiCodeGen
@TSCodeGen(exclude=true)
public abstract class ASeriesData {
    private String name;
    private long applicationId;
    private String logicalMetricName;
    private long baselineId;
    private MetricDefinition metricDefinition;
    private boolean placeholderSeries = false;
    private long granularityInMinutes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public String getLogicalMetricName() {
        return this.logicalMetricName;
    }

    public void setLogicalMetricName(String logicalMetricName) {
        this.logicalMetricName = logicalMetricName;
    }

    public boolean isBaseline() {
        return this.baselineId != -1L;
    }

    public long getBaselineId() {
        return this.baselineId;
    }

    public void setBaselineId(long baselineId) {
        this.baselineId = baselineId;
    }

    public MetricDefinition getMetricDefinition() {
        return this.metricDefinition;
    }

    public void setMetricDefinition(MetricDefinition metricDefinition) {
        this.metricDefinition = metricDefinition;
    }

    public boolean isPlaceholderSeries() {
        return this.placeholderSeries;
    }

    public void setPlaceholderSeries(boolean placeholderSeries) {
        this.placeholderSeries = placeholderSeries;
    }

    public long getGranularityInMinutes() {
        return this.granularityInMinutes;
    }

    public void setGranularityInMinutes(long granularityInMinutes) {
        this.granularityInMinutes = granularityInMinutes;
    }

    public void fillInMetaData(MetricQuery metricQuery, String logicalMetricName, MetricDefinition metricDefinition, String entityName, long baselineId, boolean seriesUsesMathExpression, int sequenceId) {
        String metricName;
        this.baselineId = baselineId;
        if (seriesUsesMathExpression) {
            logicalMetricName = metricQuery.getName();
            metricName = WidgetDataUtil.getMathDisplayName(metricQuery.getMetricMatchCriteria(), sequenceId, entityName, metricQuery.getName());
        } else {
            MetricMatchCriteria mmc = metricQuery.getMetricMatchCriteria();
            if (mmc != null && !WidgetDataUtil.isEmpty(mmc.getMetricDisplayNameCustomFormat())) {
                metricName = WidgetDataUtil.getMetricDisplayName(mmc.getMetricDisplayNameCustomFormat(), sequenceId, entityName, logicalMetricName);
            } else if (!metricQuery.isShowRawMetricName() && entityName != null) {
                boolean shouldPrependEntityName = WidgetDataUtil.shouldPrependEntityName(metricQuery.getMetricMatchCriteria().getAffectedEntityMatchCriteria());
                metricName = WidgetDataUtil.getPrettyName(entityName, logicalMetricName, shouldPrependEntityName);
            } else {
                metricName = logicalMetricName;
            }
            if (this.isBaseline()) {
                metricName = "Baseline of " + metricName;
            }
        }
        this.name = metricName = metricName.replace("|", " > ");
        this.logicalMetricName = logicalMetricName = logicalMetricName.replace("|", " > ");
        if (metricDefinition.getMetricId() != -1L) {
            this.metricDefinition = metricDefinition;
        }
        this.applicationId = metricQuery.getMetricMatchCriteria().getApplicationId();
    }

    public Double getMetricValueDoubleFromTimeslice(MetricDataTimeslice timeslice, FunctionType functionType, boolean seriesUsesMathExpression) {
        long longValue = timeslice.getMetricValue().getTypedValue(functionType);
        Double doubleValue = seriesUsesMathExpression ? Double.valueOf(Double.longBitsToDouble(longValue)) : Double.valueOf(longValue);
        return doubleValue;
    }

    public abstract void populate(MetricQuery var1, String var2, MetricDefinition var3, MetricData var4, String var5, FunctionType var6, long var7, boolean var9, int var10);
}

