/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.analytics.log;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.singularity.ee.controller.api.dto.AAppDynamicsAgent;
import com.singularity.ee.controller.api.dto.NameValuePair;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class AnalyticsAgentDetailDTO {
    private Long id;
    private boolean enabled;
    private String name;
    private String hostName;
    private String agentRuntime;
    private String installDir;
    private long installTimestamp;
    private long lastStartTimestamp;
    private long lastConnectionTimestamp;
    private int majorVersion;
    private int minorVersion;
    private int pointRelease;
    private int agentPointRelease;
    private Map<String, String> agentTags;
    private String bizTxnsHealthy;
    private String logsHealthy;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getAgentRuntime() {
        return this.agentRuntime;
    }

    public void setAgentRuntime(String agentRuntime) {
        this.agentRuntime = agentRuntime;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    public long getInstallTimestamp() {
        return this.installTimestamp;
    }

    public void setInstallTimestamp(long installTimestamp) {
        this.installTimestamp = installTimestamp;
    }

    public long getLastStartTimestamp() {
        return this.lastStartTimestamp;
    }

    public void setLastStartTimestamp(long lastStartTimestamp) {
        this.lastStartTimestamp = lastStartTimestamp;
    }

    public long getLastConnectionTimestamp() {
        return this.lastConnectionTimestamp;
    }

    public void setLastConnectionTimestamp(long lastConnectionTimestamp) {
        this.lastConnectionTimestamp = lastConnectionTimestamp;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getPointRelease() {
        return this.pointRelease;
    }

    public void setPointRelease(int pointRelease) {
        this.pointRelease = pointRelease;
    }

    public int getAgentPointRelease() {
        return this.agentPointRelease;
    }

    public void setAgentPointRelease(int agentPointRelease) {
        this.agentPointRelease = agentPointRelease;
    }

    public Map<String, String> getAgentTags() {
        return this.agentTags;
    }

    public void setAgentTags(Map<String, String> agentTags) {
        this.agentTags = agentTags;
    }

    public String getBizTxnsHealthy() {
        return this.bizTxnsHealthy;
    }

    public void setBizTxnsHealthy(String bizTxnsHealthy) {
        this.bizTxnsHealthy = bizTxnsHealthy;
    }

    public String getLogsHealthy() {
        return this.logsHealthy;
    }

    public void setLogsHealthy(String logsHealthy) {
        this.logsHealthy = logsHealthy;
    }

    public static AnalyticsAgentDetailDTO getFromAppdynamicsAgent(AAppDynamicsAgent agent) {
        AnalyticsAgentDetailDTO dto = new AnalyticsAgentDetailDTO();
        dto.setId(agent.getId());
        dto.setEnabled(!agent.isDisable());
        NameValuePair[] agentProperties = agent.getLatestAgentProperties();
        String agentName = dto.getValueFromNameValuePairs("analytics-agent-name", agentProperties);
        dto.setName(agentName);
        String hostName = dto.getValueFromNameValuePairs("analytics-agent-host-name", agentProperties);
        dto.setHostName(hostName);
        String lastConnectionTimestampString = dto.getValueFromNameValuePairs("analytics-agent-connection-timestamp", agentProperties);
        if (lastConnectionTimestampString != null) {
            try {
                dto.setLastConnectionTimestamp(Long.valueOf(lastConnectionTimestampString));
            }
            catch (NumberFormatException e) {
                dto.setLastConnectionTimestamp(0L);
            }
        }
        dto.setAgentRuntime(agent.getLatestAgentRuntime());
        dto.setInstallDir(agent.getInstallDir());
        dto.setInstallTimestamp(agent.getInstallTime().getTime());
        dto.setLastStartTimestamp(agent.getLastStartTime().getTime());
        dto.setMajorVersion(agent.getMajorRelease());
        dto.setMinorVersion(agent.getMinorRelease());
        dto.setPointRelease(agent.getPointRelease());
        dto.setAgentPointRelease(agent.getAgentPointRelease());
        HashMap<String, String> agentTags = new HashMap<String, String>();
        String prefix = "analytics-agent-tag-";
        int prefixSize = prefix.length();
        if (agentProperties != null && agentProperties.length > 0) {
            for (NameValuePair nameValuePair : agentProperties) {
                String name = nameValuePair.getName();
                String value = nameValuePair.getValue();
                if (name.length() > prefixSize && name.substring(0, prefixSize).equalsIgnoreCase(prefix)) {
                    String propertyName = name.substring(prefixSize);
                    agentTags.put(propertyName, value);
                }
                if (name.equals("analytics-agent-biz-txns-healthy")) {
                    dto.setBizTxnsHealthy(value);
                }
                if (!name.equals("analytics-agent-logs-healthy")) continue;
                dto.setLogsHealthy(value);
            }
        }
        dto.setAgentTags(agentTags);
        return dto;
    }

    private String getValueFromNameValuePairs(String propName, NameValuePair[] nameValueProps) {
        NameValuePair nvp = this.getNameValuePairByName(propName, nameValueProps);
        if (nvp != null) {
            return nvp.getValue();
        }
        return null;
    }

    private NameValuePair getNameValuePairByName(String propName, NameValuePair[] nameValueProps) {
        if (propName == null || nameValueProps == null) {
            return null;
        }
        for (NameValuePair nameValuePair : nameValueProps) {
            if (nameValuePair.getName() == null || propName == null || !nameValuePair.getName().equals(propName)) continue;
            return nameValuePair;
        }
        return null;
    }
}

