/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.MetricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@TSCodeGen(exclude=true)
public class MetricCollection {
    private final long nodeId;
    private final long applicationComponentId;
    private final long applicationId;
    private final long accountId;
    private final long timestamp;
    private final List<MetricItem> metrics = new ArrayList<MetricItem>();
    private final AgentType agentType;
    private final Set<Long> metricIds = new HashSet<Long>();

    public MetricCollection(long nodeId, long applicationComponentId, long applicationId, long accountId, long timestamp, AgentType agentType) {
        this.nodeId = nodeId;
        this.applicationComponentId = applicationComponentId;
        this.applicationId = applicationId;
        this.accountId = accountId;
        this.timestamp = timestamp;
        this.agentType = agentType;
    }

    public MetricItem getMetrics(int pos) {
        return this.metrics.get(pos);
    }

    public void addItem(MetricItem item) {
        this.metrics.add(item);
        this.metricIds.add(Long.valueOf(item.getMetricId()));
    }

    public void addItems(MetricItem ... items) {
        for (MetricItem item : items) {
            this.addItem(item);
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getApplicationComponentId() {
        return this.applicationComponentId;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<MetricItem> getMetrics() {
        return this.metrics;
    }

    public AgentType getAgentType() {
        return this.agentType;
    }

    public Set<Long> getMetricIds() {
        return this.metricIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricCollection)) {
            return false;
        }
        MetricCollection other = (MetricCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNodeId() != other.getNodeId()) {
            return false;
        }
        if (this.getApplicationComponentId() != other.getApplicationComponentId()) {
            return false;
        }
        if (this.getApplicationId() != other.getApplicationId()) {
            return false;
        }
        if (this.getAccountId() != other.getAccountId()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        List<MetricItem> this$metrics = this.getMetrics();
        List<MetricItem> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        AgentType this$agentType = this.getAgentType();
        AgentType other$agentType = other.getAgentType();
        if (this$agentType == null ? other$agentType != null : !this$agentType.equals(other$agentType)) {
            return false;
        }
        Set<Long> this$metricIds = this.getMetricIds();
        Set<Long> other$metricIds = other.getMetricIds();
        return !(this$metricIds == null ? other$metricIds != null : !((Object)this$metricIds).equals(other$metricIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $nodeId = this.getNodeId();
        result = result * 59 + (int)($nodeId >>> 32 ^ $nodeId);
        long $applicationComponentId = this.getApplicationComponentId();
        result = result * 59 + (int)($applicationComponentId >>> 32 ^ $applicationComponentId);
        long $applicationId = this.getApplicationId();
        result = result * 59 + (int)($applicationId >>> 32 ^ $applicationId);
        long $accountId = this.getAccountId();
        result = result * 59 + (int)($accountId >>> 32 ^ $accountId);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        List<MetricItem> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        AgentType $agentType = this.getAgentType();
        result = result * 59 + ($agentType == null ? 43 : $agentType.hashCode());
        Set<Long> $metricIds = this.getMetricIds();
        result = result * 59 + ($metricIds == null ? 43 : ((Object)$metricIds).hashCode());
        return result;
    }

    public String toString() {
        return "MetricCollection(nodeId=" + this.getNodeId() + ", applicationComponentId=" + this.getApplicationComponentId() + ", applicationId=" + this.getApplicationId() + ", accountId=" + this.getAccountId() + ", timestamp=" + this.getTimestamp() + ", metrics=" + this.getMetrics() + ", agentType=" + this.getAgentType() + ", metricIds=" + this.getMetricIds() + ")";
    }
}

