/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.AMetricTreeItem;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.IEntityDefinition;
import com.singularity.ee.controller.api.dto.MetricDefinition;

@UiCodeGen
@TSCodeGen(exclude=true)
public class LeafMetricTreeItem
extends AMetricTreeItem {
    private long metricId;
    private EntityType type;
    private long entityId;

    public LeafMetricTreeItem() {
    }

    public LeafMetricTreeItem(String name, long metricId, EntityType type, long entityId) {
        this.metricId = metricId;
        this.type = type;
        this.entityId = entityId;
        this.setName(name);
    }

    @Override
    public LeafMetricTreeItem shallowCopy() {
        LeafMetricTreeItem copy = new LeafMetricTreeItem();
        this.shallowCopy(copy);
        return copy;
    }

    protected void shallowCopy(LeafMetricTreeItem copy) {
        super.shallowCopy(copy);
        copy.setMetricId(this.getMetricId());
        copy.setType(this.getType());
        copy.setEntityId(this.getEntityId());
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public long getMetricId() {
        return this.metricId;
    }

    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public int hashCode() {
        return LeafMetricTreeItem.calculateHashCode(LeafMetricTreeItem.class, this.metricId, this.entityId, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LeafMetricTreeItem)) {
            return false;
        }
        LeafMetricTreeItem leafItem = (LeafMetricTreeItem)obj;
        return this.metricId == leafItem.metricId && this.type == leafItem.type && this.entityId == leafItem.entityId;
    }

    public MetricDefinition toMetricDefinition() {
        return new MetricDefinition(this.metricId, this.getName(), (IEntityDefinition)new EntityDefinition(this.type, this.entityId));
    }

    @Override
    public String toString() {
        return super.toString() + ", metricId:" + this.metricId + ", entityType:" + this.type + ", entityId:" + this.entityId;
    }

    public void setEntityDefinition(EntityDefinition def) {
        this.setEntityId(def.getEntityId());
        this.setType(def.getEntityType());
    }
}

