/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Strings;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;

@IgnoreProtoGen
@JsonIgnoreProperties(ignoreUnknown=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class LDAPGroupsQuery
extends APersistentObject {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME_ATTRIBUTE = "cn";
    private String baseDN;
    private boolean nestingEnabled;
    private String filter;
    private String nameAttribute;
    private String descriptionAttribute;
    private String userMembershipAttribute;
    private String referencedUserMembershipAttribute;
    private String dynamicGroupsFilter;
    private String dynamicGroupsMemberAttribute;
    private String nestedGroupsMemberAttribute;

    public void validate() {
        if (this.getBaseDN() == null || this.getBaseDN().length() == 0) {
            return;
        }
        if (this.getNameAttribute() == null || this.getNameAttribute().length() == 0) {
            throw new IllegalArgumentException("Missing Name Attribute");
        }
        if ("".equals(this.nestedGroupsMemberAttribute)) {
            throw new IllegalArgumentException("NestedGroupsMemberAttribute cannot be empty string");
        }
        if (this.isNestingEnabled() && this.getNestedGroupsMemberAttribute() == null && this.getUserMembershipAttribute() == null) {
            throw new IllegalArgumentException("To enable nested groups either one of UserMembershipAttribute or NestedGroupsMemberAttribute should be present ");
        }
    }

    public String getEffectiveGroupMembershipAttribute() {
        return this.getNestedGroupsMemberAttribute() != null ? this.getNestedGroupsMemberAttribute() : this.getUserMembershipAttribute();
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public boolean isNestingEnabled() {
        return this.nestingEnabled;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public String getDescriptionAttribute() {
        return this.descriptionAttribute;
    }

    public String getUserMembershipAttribute() {
        return this.userMembershipAttribute;
    }

    public String getReferencedUserMembershipAttribute() {
        return this.referencedUserMembershipAttribute;
    }

    public String getDynamicGroupsFilter() {
        return this.dynamicGroupsFilter;
    }

    public String getDynamicGroupsMemberAttribute() {
        return this.dynamicGroupsMemberAttribute;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public void setNestingEnabled(boolean nestingEnabled) {
        this.nestingEnabled = nestingEnabled;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setNameAttribute(String nameAttribute) {
        this.nameAttribute = nameAttribute;
    }

    public void setDescriptionAttribute(String descriptionAttribute) {
        this.descriptionAttribute = descriptionAttribute;
    }

    public void setUserMembershipAttribute(String userMembershipAttribute) {
        this.userMembershipAttribute = userMembershipAttribute;
    }

    public void setReferencedUserMembershipAttribute(String referencedUserMembershipAttribute) {
        this.referencedUserMembershipAttribute = referencedUserMembershipAttribute;
    }

    public void setDynamicGroupsFilter(String dynamicGroupsFilter) {
        this.dynamicGroupsFilter = dynamicGroupsFilter;
    }

    public void setDynamicGroupsMemberAttribute(String dynamicGroupsMemberAttribute) {
        this.dynamicGroupsMemberAttribute = dynamicGroupsMemberAttribute;
    }

    public String getNestedGroupsMemberAttribute() {
        if (Strings.isNullOrEmpty((String)this.nestedGroupsMemberAttribute)) {
            return null;
        }
        return this.nestedGroupsMemberAttribute;
    }

    public void setNestedGroupsMemberAttribute(String nestedGroupsMemberAttribute) {
        this.nestedGroupsMemberAttribute = nestedGroupsMemberAttribute;
    }

    private LDAPGroupsQuery(String baseDN, boolean nestingEnabled, String filter, String nameAttribute, String descriptionAttribute, String userMembershipAttribute, String referencedUserMembershipAttribute, String dynamicGroupsFilter, String dynamicGroupsMemberAttribute, String nestedGroupsMemberAttribute) {
        this.baseDN = baseDN;
        this.nestingEnabled = nestingEnabled;
        this.filter = filter;
        this.nameAttribute = nameAttribute;
        this.descriptionAttribute = descriptionAttribute;
        this.userMembershipAttribute = userMembershipAttribute;
        this.referencedUserMembershipAttribute = referencedUserMembershipAttribute;
        this.dynamicGroupsFilter = dynamicGroupsFilter;
        this.dynamicGroupsMemberAttribute = dynamicGroupsMemberAttribute;
        this.nestedGroupsMemberAttribute = nestedGroupsMemberAttribute;
    }

    public LDAPGroupsQuery() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPGroupsQuery");
        sb.append("{baseDN='").append(this.baseDN).append('\'');
        sb.append(", nestingEnabled=").append(this.nestingEnabled);
        sb.append(", filter='").append(this.filter).append('\'');
        sb.append(", nameAttribute='").append(this.nameAttribute).append('\'');
        sb.append(", descriptionAttribute='").append(this.descriptionAttribute).append('\'');
        sb.append(", userMembershipAttribute='").append(this.userMembershipAttribute).append('\'');
        sb.append(", referencedUserMembershipAttribute='").append(this.referencedUserMembershipAttribute).append('\'');
        sb.append(", dynamicGroupsFilter='").append(this.dynamicGroupsFilter).append('\'');
        sb.append(", dynamicGroupsMemberAttribute='").append(this.dynamicGroupsMemberAttribute).append('\'');
        sb.append(", nestedGroupsMemberAttribute='").append(this.nestedGroupsMemberAttribute).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class QueryBuilder {
        private String baseDN;
        private boolean nestingEnabled;
        private String filter;
        private String nameAttribute;
        private String descriptionAttribute;
        private String userMembershipAttribute;
        private String referencedUserMembershipAttribute;
        private String dynamicGroupsFilter;
        private String dynamicGroupsMemberAttribute;
        private String nestedGroupsMemberAttribute;

        public QueryBuilder setBaseDN(String baseDN) {
            this.baseDN = baseDN;
            return this;
        }

        public QueryBuilder setNestingEnabled(boolean nestingEnabled) {
            this.nestingEnabled = nestingEnabled;
            return this;
        }

        public QueryBuilder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public QueryBuilder setNameAttribute(String nameAttribute) {
            this.nameAttribute = nameAttribute;
            return this;
        }

        public QueryBuilder setDescriptionAttribute(String descriptionAttribute) {
            this.descriptionAttribute = descriptionAttribute;
            return this;
        }

        public QueryBuilder setUserMembershipAttribute(String userMembershipAttribute) {
            this.userMembershipAttribute = userMembershipAttribute;
            return this;
        }

        public QueryBuilder setReferencedUserMembershipAttribute(String referencedUserMembershipAttribute) {
            this.referencedUserMembershipAttribute = referencedUserMembershipAttribute;
            return this;
        }

        public QueryBuilder setDynamicGroupsFilter(String dynamicGroupsFilter) {
            this.dynamicGroupsFilter = dynamicGroupsFilter;
            return this;
        }

        public QueryBuilder setDynamicGroupsMemberAttribute(String dynamicGroupsMemberAttribute) {
            this.dynamicGroupsMemberAttribute = dynamicGroupsMemberAttribute;
            return this;
        }

        public QueryBuilder setNestedGroupsMemberAttribute(String nestedGroupsMemberAttribute) {
            this.nestedGroupsMemberAttribute = nestedGroupsMemberAttribute;
            return this;
        }

        public LDAPGroupsQuery createLDAPGroupsQuery() {
            return new LDAPGroupsQuery(this.baseDN, this.nestingEnabled, this.filter, this.nameAttribute, this.descriptionAttribute, this.userMembershipAttribute, this.referencedUserMembershipAttribute, this.dynamicGroupsFilter, this.dynamicGroupsMemberAttribute, this.nestedGroupsMemberAttribute);
        }
    }
}

