/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;

@IgnoreProtoGen
@UiCodeGen
@TSCodeGen(exclude=true)
public class LDAPConnectionConfig
extends APersistentObject {
    private static final long serialVersionUID = 1L;
    private String host;
    private int port;
    private boolean useSSL;
    private String bindDN;
    private String password;
    private int connectionTimeOut;
    private boolean enableReferrals;
    private int maxReferralHops = 5;

    public LDAPConnectionConfig() {
    }

    public LDAPConnectionConfig(String host, int port, boolean useSSL, String bindDN, String password) {
        this.host = host;
        this.port = port;
        this.useSSL = useSSL;
        this.bindDN = bindDN;
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public boolean isEnableReferrals() {
        return this.enableReferrals;
    }

    public void setEnableReferrals(boolean enableReferrals) {
        this.enableReferrals = enableReferrals;
    }

    public int getMaxReferralHops() {
        return this.maxReferralHops;
    }

    public void setMaxReferralHops(int maxReferralHops) {
        this.maxReferralHops = maxReferralHops;
    }

    public void validate() {
        if (this.getBindDN() == null || this.getBindDN().length() == 0) {
            throw new IllegalArgumentException("Invalid BindDN ");
        }
        if (this.getHost() == null || this.getHost().length() == 0) {
            throw new IllegalArgumentException("Invalid Host Name ");
        }
        if (this.getPort() == 0) {
            throw new IllegalArgumentException("Invalid Port ");
        }
        if (this.isEnableReferrals() && this.getMaxReferralHops() < 1) {
            throw new IllegalArgumentException("Referral Hop Limit is " + this.getMaxReferralHops() + ". It should be > 0 to enable referrals");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPConnectionConfig");
        sb.append("{host='").append(this.host).append('\'');
        sb.append(", useSSL=").append(this.useSSL);
        sb.append(", connectionTimeOut=").append(this.connectionTimeOut);
        sb.append('}');
        return sb.toString();
    }
}

