/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.singularity.ee.controller.api.constants.PagingControlType;
import com.singularity.ee.controller.api.dto.AConfigObject;
import com.singularity.ee.controller.api.dto.LDAPConnectionConfig;
import com.singularity.ee.controller.api.dto.LDAPGroupsQuery;
import com.singularity.ee.controller.api.dto.LDAPUserQuery;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;

@IgnoreProtoGen
@JsonIgnoreProperties(ignoreUnknown=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class LDAPConfiguration
extends AConfigObject {
    public static final int DEFAULT_MAX_REFERRAL_HOPS = 5;
    public static final int DEFAULT_PAGE_SIZE = 1000;
    private static final long serialVersionUID = 1L;
    private boolean enabled;
    private LDAPConnectionConfig connectionConfig;
    private LDAPUserQuery userQuery;
    private LDAPGroupsQuery groupsQuery;
    private long syncInterval;
    private long lastSyncTime;
    private boolean enablePaging = false;
    private PagingControlType pagingControlType = PagingControlType.VIRTUAL_LIST_VIEW_CONTROL;
    private int pageSize = 1000;
    private String encryptionScheme;

    public void validate() {
        if (null == this.getConnectionConfig()) {
            throw new IllegalArgumentException("Invalid Connection Configuration ");
        }
        if (null == this.getUserQuery()) {
            throw new IllegalArgumentException("Invalid User Search Configuration ");
        }
        if (this.enablePaging && this.pageSize < 1) {
            throw new IllegalArgumentException("Page Size should be > 0 to enable Paging");
        }
        this.getConnectionConfig().validate();
        this.getUserQuery().validate();
        if (null != this.getGroupsQuery()) {
            this.getGroupsQuery().validate();
        }
    }

    public LDAPConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public LDAPUserQuery getUserQuery() {
        return this.userQuery;
    }

    public LDAPGroupsQuery getGroupsQuery() {
        return this.groupsQuery;
    }

    public void setConnectionConfig(LDAPConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public void setUserQuery(LDAPUserQuery userQuery) {
        this.userQuery = userQuery;
    }

    public void setGroupsQuery(LDAPGroupsQuery groupsQuery) {
        this.groupsQuery = groupsQuery;
    }

    public long getSyncInterval() {
        return this.syncInterval;
    }

    public void setSyncInterval(long syncInterval) {
        this.syncInterval = syncInterval;
    }

    public long getLastSyncTime() {
        return this.lastSyncTime;
    }

    public void setLastSyncTime(long lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnablePaging() {
        return this.enablePaging;
    }

    public void setEnablePaging(boolean enablePaging) {
        this.enablePaging = enablePaging;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public PagingControlType getPagingControlType() {
        return this.pagingControlType;
    }

    public void setPagingControlType(PagingControlType pagingControlType) {
        this.pagingControlType = pagingControlType;
    }

    public String getEncryptionScheme() {
        return this.encryptionScheme;
    }

    public void setEncryptionScheme(String encryptionScheme) {
        this.encryptionScheme = encryptionScheme;
    }

    public GroupsResolutionType getGroupResolutionStrategy() {
        if (this.getUserQuery().getGroupsMembershipAttribute() != null && this.getUserQuery().getGroupsMembershipAttribute().length() != 0) {
            return GroupsResolutionType.USER_MEMBER;
        }
        if (this.getGroupsQuery() == null) {
            return GroupsResolutionType.DISABLED;
        }
        if (this.getGroupsQuery().getBaseDN() == null || this.getGroupsQuery().getBaseDN().length() == 0) {
            return GroupsResolutionType.DISABLED;
        }
        if (this.getGroupsQuery().getUserMembershipAttribute() != null && this.getGroupsQuery().getUserMembershipAttribute().length() != 0) {
            return GroupsResolutionType.STATIC_GROUP_MEMBER_OF;
        }
        return GroupsResolutionType.DISABLED;
    }

    public LDAPConfiguration() {
    }

    public LDAPConfiguration(LDAPConnectionConfig connectionConfig, LDAPUserQuery userQuery, LDAPGroupsQuery groupsQuery) {
        this.connectionConfig = connectionConfig;
        this.userQuery = userQuery;
        this.groupsQuery = groupsQuery;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPConfiguration");
        sb.append("{connectionConfig=").append((Object)this.connectionConfig);
        sb.append(", userQuery=").append((Object)this.userQuery);
        sb.append(", groupsQuery=").append((Object)this.groupsQuery);
        sb.append(", syncInterval=").append(this.syncInterval);
        sb.append(", lastSyncTime=").append(this.lastSyncTime);
        sb.append('}');
        return sb.toString();
    }

    @UiCodeGen
    @TSCodeGen(exclude=true)
    public static enum GroupsResolutionType {
        USER_MEMBER,
        STATIC_GROUP_MEMBER_OF,
        DYNAMIC_GROUP_MEMBER_OF,
        STATIC_AND_DYNAMIC,
        DISABLED;

    }
}

