/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.dto.AAppConfigObject;
import com.singularity.ee.controller.api.dto.JiraOAuthConfig;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.text.MessageFormat;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TSCodeGen(exclude=true)
public class JiraOAuthConfigInfo
extends AAppConfigObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraOAuthConfigInfo.class);
    private static final String LOG_ID = "ID000679";
    public static final String RSA_ALGO = "RSA";
    public static final int RSA_KEY_SIZE = 1024;
    private JiraOAuthConfig jiraOAuthConfig;
    private String rsaPrivateKey;

    public String getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public JiraOAuthConfig getJiraOAuthConfig() {
        return this.jiraOAuthConfig;
    }

    public void generateRsaKey() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(RSA_ALGO);
            keyGen.initialize(1024);
            KeyPair keyPair = keyGen.genKeyPair();
            byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
            byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
            String publicKey = DatatypeConverter.printBase64Binary((byte[])publicKeyBytes);
            String privateKey = DatatypeConverter.printBase64Binary((byte[])privateKeyBytes);
            this.setRsaKey(privateKey, publicKey);
        }
        catch (Exception e) {
            LOGGER.error(MessageFormat.format("{0} Error generating rsa key", LOG_ID), (Throwable)e);
        }
    }

    public void setRsaKey(String privateKey, String publicKey) {
        this.jiraOAuthConfig.setRsaPublicKey(publicKey);
        this.setRsaPrivateKey(privateKey);
    }

    public void setRsaPrivateKey(String privateKey) {
        this.rsaPrivateKey = privateKey;
    }

    public void setJiraOAuthConfig(JiraOAuthConfig jiraOAuthConfig) {
        this.jiraOAuthConfig = jiraOAuthConfig;
        this.setName(jiraOAuthConfig.getName());
        this.setId(jiraOAuthConfig.getId());
    }
}

