/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.controller.api.dto.GraphPoint;
import com.singularity.ee.controller.api.dto.MetricData;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import com.singularity.ee.controller.api.dto.MetricDefinition;
import com.singularity.ee.controller.api.dto.customdashboard.ASeriesData;
import com.singularity.ee.controller.api.dto.customdashboard.MetricQuery;
import java.util.ArrayList;

@UiCodeGen
@TSCodeGen(exclude=true)
public class GraphSeriesData
extends ASeriesData {
    private GraphPoint[] data;
    private GraphPoint[] standardDeviationData;
    private boolean includeAbove;
    private boolean includeBelow;
    private boolean includeBoth;
    private boolean includeBand12;
    private boolean includeBand23;
    private boolean includeBand34;
    private boolean includeBand45;
    private boolean includeShade;
    private long nextSequenceId;

    public boolean getIncludeAbove() {
        return this.includeAbove;
    }

    public void setIncludeAbove(boolean includeAbove) {
        this.includeAbove = includeAbove;
    }

    public boolean getIncludeBelow() {
        return this.includeBelow;
    }

    public void setIncludeBelow(boolean includeBelow) {
        this.includeBelow = includeBelow;
    }

    public boolean getIncludeBoth() {
        return this.includeBoth;
    }

    public void setIncludeBoth(boolean includeBoth) {
        this.includeBoth = includeBoth;
    }

    public boolean getIncludeBand12() {
        return this.includeBand12;
    }

    public void setIncludeBand12(boolean includeBand12) {
        this.includeBand12 = includeBand12;
    }

    public boolean getIncludeBand23() {
        return this.includeBand23;
    }

    public void setIncludeBand23(boolean includeBand23) {
        this.includeBand23 = includeBand23;
    }

    public boolean getIncludeBand34() {
        return this.includeBand34;
    }

    public void setIncludeBand34(boolean includeBand34) {
        this.includeBand34 = includeBand34;
    }

    public boolean getIncludeBand45() {
        return this.includeBand45;
    }

    public void setIncludeBand45(boolean includeBand45) {
        this.includeBand45 = includeBand45;
    }

    public boolean getIncludeShade() {
        return this.includeShade;
    }

    public void setIncludeShade(boolean includeShade) {
        this.includeShade = includeShade;
    }

    public GraphPoint[] getData() {
        return this.data;
    }

    public void setData(GraphPoint[] data) {
        this.data = data;
    }

    public GraphPoint[] getStandardDeviationData() {
        return this.standardDeviationData;
    }

    public void setStandardDeviationData(GraphPoint[] standardDeviationData) {
        this.standardDeviationData = standardDeviationData;
    }

    public long getNextSequenceId() {
        return this.nextSequenceId;
    }

    public void setNextSequenceId(long nextSequenceId) {
        this.nextSequenceId = nextSequenceId;
    }

    @Override
    public void populate(MetricQuery metricQuery, String logicalMetricName, MetricDefinition metricDefinition, MetricData metricData, String entityName, FunctionType functionType, long baselineId, boolean seriesUsesMathExpression, int sequenceId) {
        if (metricData == null) {
            return;
        }
        this.fillInMetaData(metricQuery, logicalMetricName, metricDefinition, entityName, baselineId, seriesUsesMathExpression, sequenceId);
        if (!"METRIC DATA NOT FOUND".equals(metricData.getMetricName()) || this.isBaseline()) {
            boolean nullPointAdded = false;
            ArrayList<GraphPoint> dataList = new ArrayList<GraphPoint>();
            ArrayList<GraphPoint> standardDeviationDataList = new ArrayList<GraphPoint>();
            for (MetricDataTimeslice mdts : metricData.getDataTimeslices()) {
                if (mdts == null || mdts.getStartTime() == null) continue;
                long time = mdts.getStartTime().getTime();
                if (mdts.getMetricValue() != null && mdts.getMetricValue().getCount() > 0L) {
                    Double value = this.getMetricValueDoubleFromTimeslice(mdts, functionType, seriesUsesMathExpression);
                    Double standardDeviationValue = mdts.getMetricValue().getStandardDeviation();
                    dataList.add(new GraphPoint(value, time));
                    standardDeviationDataList.add(new GraphPoint(standardDeviationValue, time));
                    nullPointAdded = false;
                    continue;
                }
                if (nullPointAdded) continue;
                GraphPoint gp = new GraphPoint();
                GraphPoint sdgp = new GraphPoint();
                gp.setTime(time);
                sdgp.setTime(time);
                dataList.add(gp);
                standardDeviationDataList.add(sdgp);
                nullPointAdded = true;
            }
            this.data = new GraphPoint[dataList.size()];
            this.data = dataList.toArray(this.data);
            this.standardDeviationData = new GraphPoint[standardDeviationDataList.size()];
            this.standardDeviationData = standardDeviationDataList.toArray(this.standardDeviationData);
        } else {
            super.setPlaceholderSeries(true);
        }
        this.setIncludeAbove(metricQuery.getMetricMatchCriteria().getIncludeAbove());
        this.setIncludeBelow(metricQuery.getMetricMatchCriteria().getIncludeBelow());
        this.setIncludeBoth(metricQuery.getMetricMatchCriteria().getIncludeBoth());
        this.setIncludeBand12(metricQuery.getMetricMatchCriteria().getIncludeBand12());
        this.setIncludeBand23(metricQuery.getMetricMatchCriteria().getIncludeBand23());
        this.setIncludeBand34(metricQuery.getMetricMatchCriteria().getIncludeBand34());
        this.setIncludeBand45(metricQuery.getMetricMatchCriteria().getIncludeBand45());
        this.setIncludeShade(metricQuery.getMetricMatchCriteria().getIncludeShade());
        this.setGranularityInMinutes(metricData.getGranularityMinutes());
    }
}

