/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.FilterPropertyOperator;
import com.singularity.ee.controller.api.dto.NameValuePairType;
import com.singularity.ee.controller.api.dto.SingularitySerializable;

@UiCodeGen
@TSCodeGen(exclude=true)
public class FilterProperty
implements SingularitySerializable {
    private String propertyName;
    private NameValuePairType propertyType;
    private FilterPropertyOperator operator;
    private long longValue;
    private long minValue;
    private long maxValue;
    private String[] stringValues;
    private boolean enabled;

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public FilterPropertyOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterPropertyOperator operator) {
        this.operator = operator;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
        this.enabled = true;
    }

    public String[] getStringValues() {
        return this.stringValues;
    }

    public void setStringValues(String[] stringValues) {
        this.stringValues = stringValues;
        if (this.stringValues == null) {
            return;
        }
        for (String s : stringValues) {
            if (s == null || s.trim().length() <= 0) continue;
            this.enabled = true;
            return;
        }
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.enabled = true;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.enabled = true;
    }

    public NameValuePairType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(NameValuePairType propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static FilterProperty createEquals(String propertyName, String ... equalsValue) {
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.propertyName = propertyName;
        filterProperty.propertyType = NameValuePairType.STRING;
        filterProperty.operator = FilterPropertyOperator.EQUALS;
        filterProperty.stringValues = equalsValue;
        filterProperty.enabled = true;
        return filterProperty;
    }

    public static FilterProperty createComparison(String propertyName, FilterPropertyOperator operator, long value) {
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.propertyName = propertyName;
        filterProperty.propertyType = NameValuePairType.LONG;
        filterProperty.operator = operator;
        filterProperty.longValue = value;
        filterProperty.enabled = true;
        return filterProperty;
    }

    public static FilterProperty createNone(String propertyName, NameValuePairType type) {
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.propertyName = propertyName;
        filterProperty.propertyType = type;
        filterProperty.operator = FilterPropertyOperator.NONE;
        return filterProperty;
    }

    public static FilterProperty createContains(String propertyName, String containsValue) {
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.propertyName = propertyName;
        filterProperty.propertyType = NameValuePairType.STRING;
        filterProperty.operator = FilterPropertyOperator.CONTAINS;
        filterProperty.stringValues = new String[]{containsValue};
        filterProperty.enabled = true;
        return filterProperty;
    }

    public static FilterProperty createBetween(String propertyName, long minValue, long maxValue) {
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.propertyName = propertyName;
        filterProperty.propertyType = NameValuePairType.LONG;
        filterProperty.operator = FilterPropertyOperator.BETWEEN_MIN_AND_MAX;
        filterProperty.minValue = minValue;
        filterProperty.maxValue = maxValue;
        filterProperty.enabled = true;
        return filterProperty;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" propertyName = ").append(this.propertyName).append(", ");
        result.append(" propertyType = ").append(this.propertyType).append(", ");
        result.append("  operator = ").append((Object)this.operator).append(", ");
        result.append("  longValue = ").append(this.longValue).append(", ");
        result.append("  minValue = ").append(this.minValue).append(", ");
        result.append("  maxValue = ").append(this.maxValue).append(", ");
        result.append("  stringValues = ");
        if (this.stringValues != null) {
            for (String stringValue : this.stringValues) {
                result.append(stringValue).append(", ");
            }
        } else {
            result.append("null");
        }
        return result.toString();
    }
}

