/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.singularity.ee.controller.api.constants.EUMEventTypeHelper;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.constants.TimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.CustomEventFilter;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.EventCorrelationKey;
import com.singularity.ee.controller.api.dto.FilterProperty;
import com.singularity.ee.controller.api.dto.TimeRange;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.transactionmonitor.ServerCursor;
import java.util.Collection;
import java.util.LinkedHashSet;

@JsonIgnoreProperties(ignoreUnknown=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class EventQueryScope {
    private boolean archived;
    private TimeRangeSpecifier timeRange;
    private EntityDefinition[] affectedEntities;
    private EventCorrelationKey[] correlationKeys;
    private FilterProperty[] filterProperties;
    private CustomEventFilter[] customEventFilters;
    private boolean returnMarkedAsReadEvents;
    private boolean getEventsWithoutTimeBucketing;
    private String[] eventTypesString;
    private String[] severitiesString;
    private int maxRows;
    private long startingEventId;
    private long endEventId;
    private String guid;
    private String[] subTypes;
    private EntityDefinition[] triggeredEntities;
    private ServerCursor serverCursor;

    public void eventTypeScopeFitsIntoOuterScopeOrDie(Collection<EventType> outerScope) throws Exception {
        if (this.getEventTypesString() == null || this.getEventTypesString().length == 0) {
            throw new IllegalArgumentException("Unlimited scope does not fit into: " + outerScope);
        }
        for (String singleEvenTypeString : this.getEventTypesString()) {
            EventType eventType = EventType.valueOf((String)singleEvenTypeString);
            EUMEventTypeHelper.validateEventTypeOrDie(eventType, outerScope);
        }
    }

    public boolean isCacheable(int latestRequestTime, int hoursInCache) {
        if (this.getGuid() != null && this.getGuid().length() > 0) {
            return false;
        }
        if (this.isArchived()) {
            return false;
        }
        if (this.isReturnMarkedAsReadEvents()) {
            return false;
        }
        if (this.getTimeRange() == null) {
            return false;
        }
        if (this.customEventFilters != null && this.customEventFilters.length > 0) {
            return false;
        }
        TimeRange range = this.getTimeRange().getTimeRange();
        int startTime = (int)(range.getStartTime().getTime() / 60000L);
        return latestRequestTime - startTime <= hoursInCache * 60;
    }

    public boolean hasNonCacheableItems() {
        if (this.getGuid() != null && this.getGuid().length() > 0) {
            return true;
        }
        if (this.isArchived()) {
            return true;
        }
        if (this.isReturnMarkedAsReadEvents()) {
            return true;
        }
        return this.customEventFilters != null && this.customEventFilters.length > 0;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public long getStartingEventId() {
        return this.startingEventId;
    }

    public void setStartingEventId(long startingEventId) {
        this.startingEventId = startingEventId;
    }

    public long getEndEventId() {
        return this.endEventId;
    }

    public void setEndEventId(long endEventId) {
        this.endEventId = endEventId;
    }

    public EventQueryScope() {
        TimeRangeSpecifier allTimeRange = new TimeRangeSpecifier();
        allTimeRange.setType(TimeRangeSpecifierType.ALL);
        this.timeRange = allTimeRange;
    }

    public EventType[] getEventTypes() {
        if (this.eventTypesString == null) {
            return null;
        }
        LinkedHashSet<EventType> eventTypesSet = new LinkedHashSet<EventType>();
        for (String eventTypeString : this.eventTypesString) {
            eventTypesSet.add(EventType.valueOf((String)eventTypeString));
        }
        return eventTypesSet.toArray(new EventType[eventTypesSet.size()]);
    }

    public void setEventTypes(EventType[] eventTypes) {
        if (eventTypes == null) {
            this.setEventTypesString(null);
        } else {
            String[] eventTypesString = new String[eventTypes.length];
            int i = 0;
            for (EventType type : eventTypes) {
                eventTypesString[i++] = type.name();
            }
            this.setEventTypesString(eventTypesString);
        }
    }

    public String[] getEventTypesString() {
        return this.eventTypesString;
    }

    public void setEventTypesString(String[] eventTypesString) {
        this.eventTypesString = eventTypesString;
    }

    public CustomEventFilter[] getCustomEventFilters() {
        return this.customEventFilters;
    }

    public void setCustomEventFilters(CustomEventFilter[] customEventFilters) {
        this.customEventFilters = customEventFilters;
    }

    public NotificationSeverity[] getSeverities() {
        if (this.severitiesString == null) {
            return null;
        }
        LinkedHashSet<NotificationSeverity> severitiesSet = new LinkedHashSet<NotificationSeverity>();
        for (String severityString : this.severitiesString) {
            severitiesSet.add(NotificationSeverity.valueOf((String)severityString));
        }
        return severitiesSet.toArray(new NotificationSeverity[severitiesSet.size()]);
    }

    public void setSeverities(NotificationSeverity[] severities) {
        if (severities == null) {
            this.setSeveritiesString(null);
        } else {
            String[] severitiesString = new String[severities.length];
            int i = 0;
            for (NotificationSeverity severity : severities) {
                severitiesString[i++] = severity.name();
            }
            this.setSeveritiesString(severitiesString);
        }
    }

    public String[] getSeveritiesString() {
        return this.severitiesString;
    }

    public void setSeveritiesString(String[] severitiesString) {
        this.severitiesString = severitiesString;
    }

    public TimeRangeSpecifier getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(TimeRangeSpecifier timeRange) {
        if (timeRange != null) {
            this.timeRange = timeRange;
        }
    }

    public EntityDefinition[] getAffectedEntities() {
        return this.affectedEntities;
    }

    public void setAffectedEntities(EntityDefinition[] affectedEntities) {
        this.affectedEntities = affectedEntities;
    }

    public EventCorrelationKey[] getCorrelationKeys() {
        return this.correlationKeys;
    }

    public void setCorrelationKeys(EventCorrelationKey[] correlationKeys) {
        this.correlationKeys = correlationKeys;
    }

    public boolean isReturnMarkedAsReadEvents() {
        return this.returnMarkedAsReadEvents;
    }

    public void setReturnMarkedAsReadEvents(boolean returnMarkedAsReadEvents) {
        this.returnMarkedAsReadEvents = returnMarkedAsReadEvents;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String[] getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(String[] subTypes) {
        this.subTypes = subTypes;
    }

    public EntityDefinition[] getTriggeredEntities() {
        return this.triggeredEntities;
    }

    public void setTriggeredEntities(EntityDefinition[] triggeredEntities) {
        this.triggeredEntities = triggeredEntities;
    }

    public FilterProperty[] getFilterProperties() {
        return this.filterProperties;
    }

    public void setFilterProperties(FilterProperty[] filterProperties) {
        this.filterProperties = filterProperties;
    }

    public boolean isGetEventsWithoutTimeBucketing() {
        return this.getEventsWithoutTimeBucketing;
    }

    public void setGetEventsWithoutTimeBucketing(boolean getEventsWithoutTimeBucketing) {
        this.getEventsWithoutTimeBucketing = getEventsWithoutTimeBucketing;
    }

    public ServerCursor getServerCursor() {
        return this.serverCursor;
    }

    public void setServerCursor(ServerCursor serverCursor) {
        this.serverCursor = serverCursor;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EventQueryScope:").append("\n");
        result.append("  archived = ").append(this.archived).append("\n");
        result.append("  returnMarkedAsReadEvents = ").append(this.returnMarkedAsReadEvents).append("\n");
        result.append("  maxRows = ").append(this.maxRows).append("\n");
        result.append("  startingEventId = ").append(this.startingEventId).append("\n");
        result.append("  endEventId = ").append(this.endEventId).append("\n");
        result.append("  guid = ").append(this.guid).append("\n");
        result.append("  getEventsWithoutTimeBucketing = ").append(this.getEventsWithoutTimeBucketing).append("\n");
        result.append("  timeRange = ");
        if (this.timeRange != null) {
            result.append(this.timeRange.toString()).append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" affectedEntities = ");
        if (this.affectedEntities != null) {
            for (EntityDefinition entityDefinition : this.affectedEntities) {
                result.append("\t").append(entityDefinition.toString());
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" eventTypesString = ");
        if (this.eventTypesString != null) {
            for (String string : this.eventTypesString) {
                result.append("\t").append(string.toString());
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" subTypes = ");
        if (this.subTypes != null) {
            for (String string : this.subTypes) {
                result.append("\t").append(string.toString());
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" severitiesString = ");
        if (this.severitiesString != null) {
            for (String string : this.severitiesString) {
                result.append("\t").append(string.toString());
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" correlationKeys = ");
        if (this.correlationKeys != null) {
            for (EventCorrelationKey eventCorrelationKey : this.correlationKeys) {
                result.append("\t").append(eventCorrelationKey.toString());
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" triggeredEntities = ");
        if (this.triggeredEntities != null) {
            for (EntityDefinition entityDefinition : this.triggeredEntities) {
                result.append("\t").append(entityDefinition.toString());
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        result.append(" filterProperties = ").append("\n");
        if (this.filterProperties != null) {
            void var5_30;
            boolean bl = false;
            FilterProperty[] filterPropertyArray = this.filterProperties;
            int n = filterPropertyArray.length;
            boolean bl2 = false;
            while (var5_30 < n) {
                void var2_14;
                FilterProperty fp = filterPropertyArray[var5_30];
                result.append("\t").append((int)(++var2_14)).append(" - ").append(fp.toString()).append("\n");
                ++var5_30;
            }
            result.append("\n");
        } else {
            result.append("null").append("\n");
        }
        return result.toString();
    }
}

