/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EntityType;

@UiCodeGen
@TSCodeGen(exclude=true)
public class EventOwner {
    private EntityType entityType;
    private long entityId;

    public EventOwner(EntityType entityType, long entityId) {
        this.validateEntityType(entityType);
        this.validateId(entityId);
        this.entityType = entityType;
        this.entityId = entityId;
    }

    @Deprecated
    public EventOwner() {
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Deprecated
    public void setEntityType(EntityType entityType) {
        this.validateEntityType(entityType);
        this.entityType = entityType;
    }

    public long getEntityId() {
        return this.entityId;
    }

    @Deprecated
    public void setEntityId(long entityId) {
        this.validateId(entityId);
        this.entityId = entityId;
    }

    private void validateEntityType(EntityType type) {
        switch (type) {
            case ACCOUNT: 
            case APPLICATION: 
            case MACHINE_INSTANCE: 
            case CONTROLLER_INSTANCE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("EventOwner entityType must be in " + EntityType.ACCOUNT.name() + ", " + EntityType.APPLICATION.name() + ", " + EntityType.MACHINE_INSTANCE.name() + ", " + EntityType.CONTROLLER_INSTANCE.name());
            }
        }
    }

    private void validateId(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("EventOwner entityId must be greater than 0");
        }
    }
}

