/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.constants.PerformanceState;
import com.singularity.ee.controller.api.dto.PolicyViolationEventCounts;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceStateSummary;
import com.singularity.ee.controller.api.exceptions.EventCategoryNotFoundException;

@UiCodeGen
@TSCodeGen(exclude=true)
public class EventCounts {
    private PolicyViolationEventCounts policyViolationEventCounts;
    private PerformanceStateSummary codeProblems;
    private PerformanceStateSummary applicationChanges;
    private PerformanceStateSummary appDynamicsInternalDiagnostics;
    private PerformanceStateSummary appDynamicsConfigurationWarninigs;
    private PerformanceStateSummary customEvents;
    private PerformanceStateSummary discoveryEvents;
    private PerformanceStateSummary infrastructureEvents;
    private PerformanceStateSummary networkEvents;
    private PerformanceStateSummary errorEvents;
    private long errorSnspshots;
    private long slowSnspshots;
    private PerformanceStateSummary anomalies;

    public PerformanceStateSummary getCodeProblems() {
        return this.codeProblems;
    }

    public void setCodeProblems(PerformanceStateSummary codeProblems) {
        this.codeProblems = codeProblems;
    }

    public PerformanceStateSummary getApplicationChanges() {
        return this.applicationChanges;
    }

    public void setApplicationChanges(PerformanceStateSummary applicationChanges) {
        this.applicationChanges = applicationChanges;
    }

    public PerformanceStateSummary getCustomEvents() {
        return this.customEvents;
    }

    public void setCustomEvents(PerformanceStateSummary customEvents) {
        this.customEvents = customEvents;
    }

    public PerformanceStateSummary getDiscoveryEvents() {
        return this.discoveryEvents;
    }

    public void setDiscoveryEvents(PerformanceStateSummary discoveryEvents) {
        this.discoveryEvents = discoveryEvents;
    }

    public PerformanceStateSummary getErrorEvents() {
        return this.errorEvents;
    }

    public void setErrorEvents(PerformanceStateSummary errors) {
        this.errorEvents = errors;
    }

    public PolicyViolationEventCounts getPolicyViolationEventCounts() {
        return this.policyViolationEventCounts;
    }

    public void setPolicyViolationEventCounts(PolicyViolationEventCounts policyViolationEventCounts) {
        this.policyViolationEventCounts = policyViolationEventCounts;
    }

    public PerformanceStateSummary getAppDynamicsInternalDiagnostics() {
        return this.appDynamicsInternalDiagnostics;
    }

    public void setAppDynamicsInternalDiagnostics(PerformanceStateSummary appDynamicsInternalDiagnostics) {
        this.appDynamicsInternalDiagnostics = appDynamicsInternalDiagnostics;
    }

    public PerformanceStateSummary getAppDynamicsConfigurationWarninigs() {
        return this.appDynamicsConfigurationWarninigs;
    }

    public void setAppDynamicsConfigurationWarninigs(PerformanceStateSummary appDynamicsConfigurationWarninigs) {
        this.appDynamicsConfigurationWarninigs = appDynamicsConfigurationWarninigs;
    }

    public PerformanceStateSummary getNetworkEvents() {
        return this.networkEvents;
    }

    public void setNetworkEvents(PerformanceStateSummary networkEvents) {
        this.networkEvents = networkEvents;
    }

    public PerformanceStateSummary getInfrastructureEvents() {
        return this.infrastructureEvents;
    }

    public void setInfrastructureEvents(PerformanceStateSummary infrastructureEvents) {
        this.infrastructureEvents = infrastructureEvents;
    }

    public long getErrorSnspshots() {
        return this.errorSnspshots;
    }

    public void setErrorSnspshots(long errorSnspshots) {
        this.errorSnspshots = errorSnspshots;
    }

    public long getSlowSnspshots() {
        return this.slowSnspshots;
    }

    public void setSlowSnspshots(long slowSnspshots) {
        this.slowSnspshots = slowSnspshots;
    }

    public PerformanceStateSummary getAnomalies() {
        return this.anomalies;
    }

    public void setAnomalies(PerformanceStateSummary anomalies) {
        this.anomalies = anomalies;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.policyViolationEventCounts.hashCode();
        result = 37 * result + this.codeProblems.hashCode();
        result = 37 * result + this.applicationChanges.hashCode();
        result = 37 * result + this.appDynamicsInternalDiagnostics.hashCode();
        result = 37 * result + this.appDynamicsConfigurationWarninigs.hashCode();
        result = 37 * result + this.customEvents.hashCode();
        result = 37 * result + this.discoveryEvents.hashCode();
        result = 37 * result + this.infrastructureEvents.hashCode();
        result = 37 * result + this.networkEvents.hashCode();
        result = 37 * result + this.errorEvents.hashCode();
        result = 37 * result + (int)this.errorSnspshots;
        result = 37 * result + (int)this.slowSnspshots;
        result = 37 * result + this.anomalies.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventCounts other = (EventCounts)object;
        return this.policyViolationEventCounts.equals(other.getPolicyViolationEventCounts()) && this.codeProblems.equals((Object)other.getCodeProblems()) && this.applicationChanges.equals((Object)other.getApplicationChanges()) && this.appDynamicsInternalDiagnostics.equals((Object)other.getAppDynamicsInternalDiagnostics()) && this.appDynamicsConfigurationWarninigs.equals((Object)other.getAppDynamicsConfigurationWarninigs()) && this.customEvents.equals((Object)other.getCustomEvents()) && this.discoveryEvents.equals((Object)other.getDiscoveryEvents()) && this.infrastructureEvents.equals((Object)other.getInfrastructureEvents()) && this.networkEvents.equals((Object)other.getNetworkEvents()) && this.errorEvents.equals((Object)other.getErrorEvents()) && this.errorSnspshots == other.getErrorSnspshots() && this.slowSnspshots == other.getSlowSnspshots() && this.anomalies.equals((Object)other.getAnomalies());
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("policyViolationEventCounts = %3s" + newline, this.policyViolationEventCounts.toString()));
        ret.append(String.format("codeProblems = %3s" + newline, this.codeProblems.toString()));
        ret.append(String.format("applicationChanges = %3s" + newline, this.applicationChanges.toString()));
        ret.append(String.format("appDynamicsInternalDiagnostics = %3s" + newline, this.appDynamicsInternalDiagnostics.toString()));
        ret.append(String.format("appDynamicsConfigurationWarninigs = %3s" + newline, this.appDynamicsConfigurationWarninigs.toString()));
        ret.append(String.format("customEvents = %3s" + newline, this.customEvents.toString()));
        ret.append(String.format("infrastructureEvents = %3s" + newline, this.infrastructureEvents.toString()));
        ret.append(String.format("networkEvents = %3s" + newline, this.networkEvents.toString()));
        ret.append(String.format("errorEvents = %3s" + newline, this.errorEvents.toString()));
        ret.append(String.format("errorSnspshots = %3s" + newline, Long.toString(this.errorSnspshots)));
        ret.append(String.format("slowSnspshots = %3s" + newline, Long.toString(this.slowSnspshots)));
        return ret.toString();
    }

    public void increment(String eventTypeCategory, String severity, int value) throws EventCategoryNotFoundException {
        switch (eventTypeCategory) {
            case "TOTAL_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "OVERALL_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getOverallApplicationPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "BUSINESS_TRANSACTION_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getBusinessTransactionPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "NODE_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getNodePolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "ERROR_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getErrorPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "BACKEND_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getBackendPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "DB_SERVER_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getDbServerPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "INFORMATION_POINT_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getInformationPointPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "MOBILE_APPLICATION_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getMobileApplicationPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "CUSTOM_POLICY_VIOLATIONS": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getPolicyViolationEventCounts().getCustomPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                this.getPolicyViolationEventCounts().getTotalPolicyViolations().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "ERROR_EVENTS": {
                this.getErrorEvents().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "TOTAL_ANOMALIES": {
                if (severity.equals(NotificationSeverity.INFO.name())) break;
                this.getAnomalies().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "CODE_PROBLEMS": {
                this.getCodeProblems().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "APPLICATION_CHANGES": {
                this.getApplicationChanges().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "INTERNAL_DIAGNOSTICS": {
                this.getAppDynamicsInternalDiagnostics().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "CONFIGURATION_WARNINGS": {
                this.getAppDynamicsConfigurationWarninigs().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "INFRASTRUCTURE_EVENTS": {
                this.getInfrastructureEvents().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "CUSTOM_EVENTS": {
                this.getCustomEvents().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "DISCOVERY_EVENTS": {
                this.getDiscoveryEvents().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            case "NETWORK_EVENTS": {
                this.getNetworkEvents().increment((PerformanceState)PerformanceState.severityPerformanceStateMap.get(severity), (long)value);
                break;
            }
            default: {
                throw new EventCategoryNotFoundException("EventTypeCategory [ " + eventTypeCategory + "] not found.");
            }
        }
    }
}

