/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.ApplicationDiagnosticDataType;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.ContainerMetricTreeItem;
import com.singularity.ee.controller.api.dto.EntityDefinition;

@UiCodeGen
@TSCodeGen(exclude=true)
public class ApplicationDiagnosticDataMetricTreeItem
extends ContainerMetricTreeItem {
    private long aDDId;
    private ApplicationDiagnosticDataType type;
    private long componentId;

    public ApplicationDiagnosticDataMetricTreeItem(long aDDId) {
        this.aDDId = aDDId;
    }

    public ApplicationDiagnosticDataMetricTreeItem() {
    }

    public ApplicationDiagnosticDataMetricTreeItem(long aDDId, String name, ApplicationDiagnosticDataType diagnosticType) {
        this.setName(name);
        this.aDDId = aDDId;
        this.type = diagnosticType;
    }

    @Override
    public ApplicationDiagnosticDataMetricTreeItem shallowCopy() {
        ApplicationDiagnosticDataMetricTreeItem copy = new ApplicationDiagnosticDataMetricTreeItem();
        this.shallowCopy(copy);
        return copy;
    }

    private void shallowCopy(ApplicationDiagnosticDataMetricTreeItem copy) {
        super.shallowCopy(copy);
        copy.setADDId(this.getADDId());
        copy.setType(this.getType());
    }

    public long getADDId() {
        return this.aDDId;
    }

    public void setADDId(long aDDId) {
        this.aDDId = aDDId;
    }

    public ApplicationDiagnosticDataType getType() {
        return this.type;
    }

    public void setType(ApplicationDiagnosticDataType type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        return ApplicationDiagnosticDataMetricTreeItem.calculateHashCode(ApplicationDiagnosticDataMetricTreeItem.class, this.aDDId);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationDiagnosticDataMetricTreeItem)) {
            return false;
        }
        return this.aDDId == ((ApplicationDiagnosticDataMetricTreeItem)obj).aDDId;
    }

    public long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(long componentId) {
        this.componentId = componentId;
    }

    @Override
    public String toString() {
        return super.toString() + "| aDDId:" + this.aDDId + "| component id:" + this.componentId;
    }

    @Override
    public EntityDefinition[] getEntityDefinitions() {
        EntityType entityType;
        switch (this.getType()) {
            case COLLECTIONS: {
                entityType = EntityType.AUTOMATIC_LEAK_DETECTION;
                break;
            }
            case MEMORY: {
                entityType = EntityType.CUSTOM_MEMORY_STRUCTURE;
                break;
            }
            case TRACKED_OBJECT: {
                entityType = EntityType.OBJECT_INSTANCE_TRACKING;
                break;
            }
            case ERROR: 
            case STACK_TRACE: {
                entityType = EntityType.ERROR;
                break;
            }
            case THREAD_TASK: {
                entityType = EntityType.THREAD_TASK;
                break;
            }
            case BASE_PAGE: {
                entityType = EntityType.BASE_PAGE;
                break;
            }
            case IFRAME: {
                entityType = EntityType.IFRAME;
                break;
            }
            case VIRTUAL_PAGE: {
                entityType = EntityType.VIRTUAL_PAGE;
                break;
            }
            case AJAX_REQUEST: {
                entityType = EntityType.AJAX_REQUEST;
                break;
            }
            case SYNTH_JOB_REF: {
                entityType = EntityType.SYNTH_JOB_REF;
                break;
            }
            case MOBILE_REQUEST: {
                entityType = EntityType.MOBILE_NETWORK_REQUEST;
                break;
            }
            case SERVICE_ENDPOINT: {
                entityType = EntityType.SERVICE_END_POINT;
                break;
            }
            default: {
                entityType = null;
            }
        }
        return new EntityDefinition[]{new EntityDefinition(entityType, this.getADDId())};
    }
}

