/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.TimeRange;

@UiCodeGen
@TSCodeGen(exclude=true)
public enum TopSummaryStatsFrequency {
    FIVE_MIN,
    HOUR,
    HALF_DAY;


    public long getRoundedNumberOfMinutes(TimeRange range) {
        int frequencyMinutes;
        long diffInSecs = range.getEndTime().getTime() - range.getStartTime().getTime();
        long noOfFrequencyPoints = diffInSecs / (long)(60000 * (frequencyMinutes = this.getFrequencyMinutes()));
        return (noOfFrequencyPoints == 0L ? 1L : noOfFrequencyPoints) * (long)frequencyMinutes;
    }

    public int getFrequencyMinutes() {
        switch (this) {
            case FIVE_MIN: {
                return 5;
            }
            case HOUR: {
                return 60;
            }
            case HALF_DAY: {
                return 720;
            }
        }
        throw new IllegalArgumentException((Object)((Object)this) + " is not supported");
    }

    public static long getFrequencyInMilliseconds(TopSummaryStatsFrequency frequency) {
        switch (frequency) {
            case FIVE_MIN: {
                return 300000L;
            }
            case HOUR: {
                return 3600000L;
            }
            case HALF_DAY: {
                return 43200000L;
            }
        }
        throw new IllegalArgumentException((Object)((Object)frequency) + " is not supported");
    }
}

