/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.AgentType;
import java.util.ArrayList;
import java.util.List;

@UiCodeGen
@TSCodeGen(exclude=true)
public enum SimplifiedAgentType {
    APP_AGENT,
    MACHINE_AGENT,
    DB_COLLECTOR,
    ANALYTICS_AGENT,
    NETVIZ_AGENT,
    DB_AGENT;


    public static SimplifiedAgentType getSimplifiedAgentType(AgentType agentType) {
        if (agentType == null) {
            throw new NullPointerException("agent type is not specified");
        }
        String string = agentType.toString();
        if (string.endsWith("APP_AGENT") || string.startsWith("NATIVE") || agentType == AgentType.GOLANG_SDK || agentType == AgentType.WMB_AGENT) {
            return APP_AGENT;
        }
        if (string.endsWith("MACHINE_AGENT")) {
            return MACHINE_AGENT;
        }
        if (string.endsWith("NETVIZ_AGENT")) {
            return NETVIZ_AGENT;
        }
        if (agentType == AgentType.DB_COLLECTOR) {
            return DB_COLLECTOR;
        }
        if (agentType == AgentType.DB_AGENT) {
            return DB_AGENT;
        }
        if (agentType.equals((Object)AgentType.ANALYTICS_AGENT)) {
            return ANALYTICS_AGENT;
        }
        throw new IllegalStateException();
    }

    public static boolean isAppAgent(AgentType agentType) {
        return SimplifiedAgentType.getSimplifiedAgentType(agentType) == APP_AGENT;
    }

    public static List<AgentType> getAppAgentTypes() {
        ArrayList<AgentType> list = new ArrayList<AgentType>();
        for (AgentType agentType : AgentType.values()) {
            if (!SimplifiedAgentType.isAppAgent(agentType)) continue;
            list.add(agentType);
        }
        return list;
    }

    public static boolean isProxyBasedAgent(AgentType agentType) {
        switch (agentType) {
            case PHP_APP_AGENT: 
            case NODEJS_APP_AGENT: 
            case PYTHON_APP_AGENT: {
                return true;
            }
        }
        return false;
    }
}

