/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.Severity;
import java.util.HashMap;
import java.util.Map;

public class SeverityHelper {
    private static Map<Severity, SeverityHelper> sevs = new HashMap<Severity, SeverityHelper>();
    private final int precedence;
    private final String imageName;

    private SeverityHelper(int precedence, String imageName) {
        this.precedence = precedence;
        this.imageName = imageName;
    }

    public static boolean isLesserPrecedence(Severity mySeverity, Severity severity) {
        return SeverityHelper.sevs.get((Object)mySeverity).precedence < SeverityHelper.sevs.get((Object)severity).precedence;
    }

    public static String getImageName(Severity severity) {
        return SeverityHelper.sevs.get((Object)severity).imageName;
    }

    static {
        sevs.put(Severity.INFO, new SeverityHelper(0, "info"));
        sevs.put(Severity.WARNING, new SeverityHelper(1, "warning"));
        sevs.put(Severity.CRITICAL, new SeverityHelper(2, "critical"));
    }
}

