/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.OverageMetricDetails;
import java.util.HashMap;
import java.util.Map;

@UiCodeGen
@TSCodeGen(exclude=true)
public class OverageEventTypeMetrics {
    static String[] BRUM_EVENT_TYPES = new String[]{"sessionrecord", "browserrecord", "browsererrorrecord", "browserresourcerecord", "eumusagerecord", "webuserjourney"};
    static String[] MRUM_EVENT_TYPES = new String[]{"mobilesnapshot", "mobilesessionrecord", "mobilenonfatalissuerecord", "mobilecrashreport", "mobileuserjourney"};
    static String[] TA_EVENT_TYPES = new String[]{"biz_txn_v.*", "custom_.*"};

    public static Map<String, OverageMetricDetails> getOverageMetricDetailsMap() {
        HashMap<String, OverageMetricDetails> overageMetricDetailsMap = new HashMap<String, OverageMetricDetails>();
        for (String eventType : BRUM_EVENT_TYPES) {
            overageMetricDetailsMap.put(eventType, OverageEventTypeMetrics.createMetricDetailsBRUM(eventType));
        }
        for (String eventType : MRUM_EVENT_TYPES) {
            overageMetricDetailsMap.put(eventType, OverageEventTypeMetrics.createMetricDetailsMRUM(eventType));
        }
        for (String eventType : TA_EVENT_TYPES) {
            overageMetricDetailsMap.put(eventType, OverageEventTypeMetrics.createMetricDetailsTA(eventType));
        }
        return overageMetricDetailsMap;
    }

    public static OverageMetricDetails createMetricDetailsMRUM(String eventType) {
        return new OverageMetricDetails("mrum", "Mobile Overage Usage", eventType);
    }

    public static OverageMetricDetails createMetricDetailsTA(String eventType) {
        return new OverageMetricDetails("ta", "TA Overage Usage", eventType);
    }

    public static OverageMetricDetails createMetricDetailsBRUM(String eventType) {
        return new OverageMetricDetails("brum", "Browser Overage Usage", eventType);
    }
}

