/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.MetricDataFrequency;
import com.singularity.ee.controller.api.dto.TimeRange;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;

public class MetricDataFrequencyHelper {
    public static final EnumSet<MetricDataFrequency> ValidFrequencies = EnumSet.of(MetricDataFrequency.ONE_MIN, MetricDataFrequency.TEN_MIN, MetricDataFrequency.SIXTY_MIN);

    public static long getRoundedNumberOfMinutes(MetricDataFrequency frequency, TimeRange range) {
        int frequencyMinutes;
        long diffInSecs = range.getEndTime().getTime() - range.getStartTime().getTime();
        long noOfFrequencyPoints = diffInSecs / (long)(60000 * (frequencyMinutes = MetricDataFrequencyHelper.getFrequencyMinutes(frequency)));
        return (noOfFrequencyPoints == 0L ? 1L : noOfFrequencyPoints) * (long)frequencyMinutes;
    }

    public static int getFrequencyMinutes(MetricDataFrequency frequency) {
        switch (frequency) {
            case ONE_MIN: {
                return 1;
            }
            case TEN_MIN: {
                return 10;
            }
            case SIXTY_MIN: {
                return 60;
            }
            case NO_DATA: {
                return 0;
            }
            case CUSTOM: {
                throw new IllegalArgumentException("Cannot calculate exact frequency for CUSTOM. Use value from MetricData instead.");
            }
        }
        throw new IllegalArgumentException(frequency + " is not supported");
    }

    @Deprecated
    public static long truncate(MetricDataFrequency frequency, long time) {
        if (frequency == MetricDataFrequency.NO_DATA) {
            return time;
        }
        return time - time % MetricDataFrequencyHelper.getMillis(frequency);
    }

    public static long truncate(long granularityMinutes, long time) {
        if (granularityMinutes <= 0L) {
            return time;
        }
        return time - time % TimeUnit.MINUTES.toMillis(granularityMinutes);
    }

    public static long getMillis(MetricDataFrequency frequency) {
        return MetricDataFrequencyHelper.getFrequencyMinutes(frequency) * 60000;
    }
}

