/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.util.string.StringOperations;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
@UiCodeGen
@TSCodeGen(exclude=true)
public enum LicenseModuleType {
    JAVA,
    DOT_NET,
    MACHINE_AGENT,
    PHP,
    NODEJS,
    C_PLUSPLUS,
    NATIVE_DYNAMIC,
    NATIVE_SDK,
    NATIVE_WEB_SERVER,
    GOLANG_SDK,
    WMB_AGENT,
    PYTHON,
    RUBY,
    DATABASE,
    APM,
    LOG_ANALYTICS,
    TRANSACTION_ANALYTICS,
    MOBILE_ANALYTICS,
    BROWSER_ANALYTICS,
    SYNTHETIC,
    SYNTHETIC_PRIVATE_AGENT,
    BROWSER_RUM,
    MOBILE_RUM,
    UNIFIED_RUM,
    IOT,
    APM_MACHINE_AGENT,
    SIM_MACHINE_AGENT,
    SERVICE_AVAIL_MON,
    NETVIZ;

    public static final int CPLUSPLUS_INSTANCE_PER_LICENSE_UNIT = 3;
    public static final int GO_AGENT_PER_LICENSE_UNIT = 3;
    public static final int NODEJS_AGENT_PER_LICENSE_UNIT = 10;
    private static Logger logger;
    private static final Map<AgentType, LicenseModuleType> agentVsModuleTypeMapping;
    private static final Set<LicenseModuleType> APM_AGENT_LICENSE_TYPES;
    private static final Set<LicenseModuleType> APM_LICENSE_TYPES;
    private static final Set<LicenseModuleType> ANALYTICS_LICENSE_TYPES;
    private static final Set<LicenseModuleType> EUM_LICENSE_TYPES;
    private static final Set<LicenseModuleType> INFRA_LICENSE_TYPES;
    private static final Set<LicenseModuleType> MDS_LICENSE_TYPES;
    private final String prettyName = this.name().toLowerCase().replace('_', '-');

    public String getName() {
        return this.prettyName;
    }

    public static LicenseModuleType fromLicenseModuleTypeName(String name) {
        String upperName = StringOperations.toUppercaseEnglishLocale((String)name);
        upperName = upperName.replace('-', '_');
        return LicenseModuleType.valueOf(upperName);
    }

    public static LicenseModuleType fromAgentType(AgentType agentType) {
        LicenseModuleType licenseModuleType = agentVsModuleTypeMapping.get(agentType);
        if (licenseModuleType == null) {
            throw new IllegalArgumentException("AgentType: " + agentType + " has no mapping");
        }
        return licenseModuleType;
    }

    public static boolean isValidLicenseModuleName(String licenseModuleName) {
        try {
            LicenseModuleType.fromLicenseModuleTypeName(licenseModuleName);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, "Illegal license module name passed: " + licenseModuleName);
            return false;
        }
        return true;
    }

    public long calculateLicenseUsageFromUnitCount(long unitCount, boolean isApmAgentLicense) {
        if (unitCount < 0L) {
            throw new IllegalArgumentException("unitCount can't be negative");
        }
        if (unitCount == 0L) {
            return 0L;
        }
        switch (this) {
            case NATIVE_SDK: {
                if (!isApmAgentLicense) {
                    return unitCount;
                }
                return (unitCount + 3L - 1L) / 3L;
            }
            case GOLANG_SDK: {
                return (unitCount + 3L - 1L) / 3L;
            }
            case NODEJS: {
                return (unitCount + 10L - 1L) / 10L;
            }
        }
        return unitCount;
    }

    public long getMaxUnitCountFromLicenseCount(long licenseCount, boolean isApmAgentLicense) {
        if (licenseCount < 0L) {
            throw new IllegalArgumentException("licenseCount can't be negative");
        }
        switch (this) {
            case NATIVE_SDK: {
                if (!isApmAgentLicense) {
                    return licenseCount;
                }
                return licenseCount * 3L;
            }
            case GOLANG_SDK: {
                return licenseCount * 3L;
            }
            case NODEJS: {
                return licenseCount * 10L;
            }
        }
        return licenseCount;
    }

    public static Set<LicenseModuleType> apmAgentLicenseTypes() {
        return APM_AGENT_LICENSE_TYPES;
    }

    public static Set<LicenseModuleType> apmLicenseTypes() {
        return APM_LICENSE_TYPES;
    }

    public static Set<LicenseModuleType> eumLicenseTypes() {
        return EUM_LICENSE_TYPES;
    }

    public static Set<LicenseModuleType> analyticsLicenseTypes() {
        return ANALYTICS_LICENSE_TYPES;
    }

    public static Set<LicenseModuleType> infraLicenseTypes() {
        return INFRA_LICENSE_TYPES;
    }

    public static Set<LicenseModuleType> mdsLicenseTypes() {
        return MDS_LICENSE_TYPES;
    }

    static {
        logger = Logger.getLogger(LicenseModuleType.class.getName());
        agentVsModuleTypeMapping = new HashMap<AgentType, LicenseModuleType>();
        agentVsModuleTypeMapping.put(AgentType.APP_AGENT, JAVA);
        agentVsModuleTypeMapping.put(AgentType.DOT_NET_APP_AGENT, DOT_NET);
        agentVsModuleTypeMapping.put(AgentType.MACHINE_AGENT, MACHINE_AGENT);
        agentVsModuleTypeMapping.put(AgentType.DOT_NET_MACHINE_AGENT, MACHINE_AGENT);
        agentVsModuleTypeMapping.put(AgentType.PHP_MACHINE_AGENT, MACHINE_AGENT);
        agentVsModuleTypeMapping.put(AgentType.NODEJS_MACHINE_AGENT, MACHINE_AGENT);
        agentVsModuleTypeMapping.put(AgentType.PYTHON_APP_AGENT, PYTHON);
        agentVsModuleTypeMapping.put(AgentType.PHP_APP_AGENT, PHP);
        agentVsModuleTypeMapping.put(AgentType.NODEJS_APP_AGENT, NODEJS);
        agentVsModuleTypeMapping.put(AgentType.NATIVE_SDK, NATIVE_SDK);
        agentVsModuleTypeMapping.put(AgentType.GOLANG_SDK, GOLANG_SDK);
        agentVsModuleTypeMapping.put(AgentType.WMB_AGENT, WMB_AGENT);
        agentVsModuleTypeMapping.put(AgentType.NATIVE_WEB_SERVER, NATIVE_WEB_SERVER);
        agentVsModuleTypeMapping.put(AgentType.DB_COLLECTOR, DATABASE);
        agentVsModuleTypeMapping.put(AgentType.DB_AGENT, DATABASE);
        agentVsModuleTypeMapping.put(AgentType.SIM_MACHINE_AGENT, SIM_MACHINE_AGENT);
        agentVsModuleTypeMapping.put(AgentType.SERVICE_AVAIL_MACHINE_AGENT, SERVICE_AVAIL_MON);
        agentVsModuleTypeMapping.put(AgentType.APM_APP_AGENT, APM);
        agentVsModuleTypeMapping.put(AgentType.NETVIZ_AGENT, NETVIZ);
        HashSet<LicenseModuleType> apmAgentLicenseTypes = new HashSet<LicenseModuleType>();
        apmAgentLicenseTypes.add(JAVA);
        apmAgentLicenseTypes.add(DOT_NET);
        apmAgentLicenseTypes.add(GOLANG_SDK);
        apmAgentLicenseTypes.add(PHP);
        apmAgentLicenseTypes.add(NODEJS);
        apmAgentLicenseTypes.add(NATIVE_SDK);
        apmAgentLicenseTypes.add(NATIVE_WEB_SERVER);
        apmAgentLicenseTypes.add(PYTHON);
        apmAgentLicenseTypes.add(WMB_AGENT);
        APM_AGENT_LICENSE_TYPES = Collections.unmodifiableSet(apmAgentLicenseTypes);
        HashSet<LicenseModuleType> apmLicenseTypes = new HashSet<LicenseModuleType>();
        apmLicenseTypes.add(JAVA);
        apmLicenseTypes.add(DOT_NET);
        apmLicenseTypes.add(MACHINE_AGENT);
        apmLicenseTypes.add(PHP);
        apmLicenseTypes.add(NODEJS);
        apmLicenseTypes.add(NATIVE_SDK);
        apmLicenseTypes.add(GOLANG_SDK);
        apmLicenseTypes.add(WMB_AGENT);
        apmLicenseTypes.add(NATIVE_WEB_SERVER);
        apmLicenseTypes.add(PYTHON);
        apmLicenseTypes.add(DATABASE);
        apmLicenseTypes.add(APM);
        APM_LICENSE_TYPES = Collections.unmodifiableSet(apmLicenseTypes);
        HashSet<LicenseModuleType> analyticsLicenseTypes = new HashSet<LicenseModuleType>();
        analyticsLicenseTypes.add(LOG_ANALYTICS);
        analyticsLicenseTypes.add(TRANSACTION_ANALYTICS);
        analyticsLicenseTypes.add(MOBILE_ANALYTICS);
        analyticsLicenseTypes.add(BROWSER_ANALYTICS);
        ANALYTICS_LICENSE_TYPES = Collections.unmodifiableSet(analyticsLicenseTypes);
        HashSet<LicenseModuleType> eumLicenseTypes = new HashSet<LicenseModuleType>();
        eumLicenseTypes.add(SYNTHETIC);
        eumLicenseTypes.add(SYNTHETIC_PRIVATE_AGENT);
        eumLicenseTypes.add(BROWSER_RUM);
        eumLicenseTypes.add(MOBILE_RUM);
        eumLicenseTypes.add(UNIFIED_RUM);
        eumLicenseTypes.add(IOT);
        EUM_LICENSE_TYPES = Collections.unmodifiableSet(eumLicenseTypes);
        HashSet<LicenseModuleType> infraLicenseTypes = new HashSet<LicenseModuleType>();
        infraLicenseTypes.add(SIM_MACHINE_AGENT);
        infraLicenseTypes.add(SERVICE_AVAIL_MON);
        infraLicenseTypes.add(NETVIZ);
        INFRA_LICENSE_TYPES = Collections.unmodifiableSet(infraLicenseTypes);
        HashSet<LicenseModuleType> mdsLicenseTypes = new HashSet<LicenseModuleType>();
        mdsLicenseTypes.add(JAVA);
        mdsLicenseTypes.add(DOT_NET);
        mdsLicenseTypes.add(MACHINE_AGENT);
        mdsLicenseTypes.add(PHP);
        mdsLicenseTypes.add(NODEJS);
        mdsLicenseTypes.add(NATIVE_SDK);
        mdsLicenseTypes.add(GOLANG_SDK);
        mdsLicenseTypes.add(WMB_AGENT);
        mdsLicenseTypes.add(NATIVE_WEB_SERVER);
        mdsLicenseTypes.add(PYTHON);
        mdsLicenseTypes.add(APM);
        mdsLicenseTypes.add(SIM_MACHINE_AGENT);
        mdsLicenseTypes.add(SERVICE_AVAIL_MON);
        mdsLicenseTypes.add(NETVIZ);
        MDS_LICENSE_TYPES = Collections.unmodifiableSet(mdsLicenseTypes);
    }
}

