/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.HttpResponseStatus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HttpResponseStatusHelper {
    private static final Map<HttpResponseStatus, HttpResponseStatusHelper> helperByStatus;
    private static final Map<Integer, HttpResponseStatusHelper> helperByCode;
    private static final Set<HttpResponseStatus> informationalStatuses;
    private static final Set<HttpResponseStatus> successfulStatuses;
    private static final Set<HttpResponseStatus> redirectionStatuses;
    private static final Set<HttpResponseStatus> clientErrorStatuses;
    private static final Set<HttpResponseStatus> serverErrorStatuses;
    private static final Set<Integer> informationalCodes;
    private static final Set<Integer> successfulCodes;
    private static final Set<Integer> redirectionCodes;
    private static final Set<Integer> clientErrorCodes;
    private static final Set<Integer> serverErrorCodes;
    private final int code;
    private final HttpResponseStatus status;
    private final String reason;
    private final String link;

    public static Integer codeByStatus(HttpResponseStatus status) {
        HttpResponseStatusHelper helper = helperByStatus.get((Object)status);
        return helper == null ? null : Integer.valueOf(helper.code);
    }

    public static HttpResponseStatus statusBycode(int code) {
        HttpResponseStatusHelper helper = helperByCode.get(code);
        return helper == null ? null : helper.status;
    }

    public static String reasonByStatus(HttpResponseStatus status) {
        HttpResponseStatusHelper helper = helperByStatus.get((Object)status);
        return helper == null ? null : helper.reason;
    }

    public static String reasonBycode(int code) {
        HttpResponseStatusHelper helper = helperByCode.get(code);
        return helper == null ? null : helper.reason;
    }

    public static String linkByStatus(HttpResponseStatus status) {
        HttpResponseStatusHelper helper = helperByStatus.get((Object)status);
        return helper == null ? null : helper.link;
    }

    public static String linkBycode(int code) {
        HttpResponseStatusHelper helper = helperByCode.get(code);
        return helper == null ? null : helper.link;
    }

    public static Set<HttpResponseStatus> getInformationalStatuses() {
        return informationalStatuses;
    }

    public static Set<HttpResponseStatus> getSuccessfulStatuses() {
        return successfulStatuses;
    }

    public static Set<HttpResponseStatus> getRedirectionStatuses() {
        return redirectionStatuses;
    }

    public static Set<HttpResponseStatus> getClientErrorStatuses() {
        return clientErrorStatuses;
    }

    public static Set<HttpResponseStatus> getServerErrorStatuses() {
        return serverErrorStatuses;
    }

    public static Set<Integer> getInformationalCodes() {
        return informationalCodes;
    }

    public static Set<Integer> getSuccessfulCodes() {
        return successfulCodes;
    }

    public static Set<Integer> getRedirectionCodes() {
        return redirectionCodes;
    }

    public static Set<Integer> getClientErrorCodes() {
        return clientErrorCodes;
    }

    public static Set<Integer> getServerErrorCodes() {
        return serverErrorCodes;
    }

    private HttpResponseStatusHelper(int code, HttpResponseStatus status, String reason, String link) {
        this.code = code;
        this.status = status;
        this.reason = reason;
        this.link = link;
    }

    static {
        HttpResponseStatusHelper[] httpResponseStatusHelpers;
        helperByStatus = new HashMap<HttpResponseStatus, HttpResponseStatusHelper>();
        helperByCode = new HashMap<Integer, HttpResponseStatusHelper>();
        informationalStatuses = new HashSet<HttpResponseStatus>();
        successfulStatuses = new HashSet<HttpResponseStatus>();
        redirectionStatuses = new HashSet<HttpResponseStatus>();
        clientErrorStatuses = new HashSet<HttpResponseStatus>();
        serverErrorStatuses = new HashSet<HttpResponseStatus>();
        informationalCodes = new HashSet<Integer>();
        successfulCodes = new HashSet<Integer>();
        redirectionCodes = new HashSet<Integer>();
        clientErrorCodes = new HashSet<Integer>();
        serverErrorCodes = new HashSet<Integer>();
        block7: for (HttpResponseStatusHelper helper : httpResponseStatusHelpers = new HttpResponseStatusHelper[]{new HttpResponseStatusHelper(100, HttpResponseStatus.CONTINUE, "Continue", "https://tools.ietf.org/html/rfc7231#section-6.2.1"), new HttpResponseStatusHelper(101, HttpResponseStatus.SWITCHING_PROTOCOLS, "Switching Protocols", "https://tools.ietf.org/html/rfc7231#section-6.2.2"), new HttpResponseStatusHelper(200, HttpResponseStatus.OK, "OK", "https://tools.ietf.org/html/rfc7231#section-6.3.1"), new HttpResponseStatusHelper(201, HttpResponseStatus.CREATED, "Created", "https://tools.ietf.org/html/rfc7231#section-6.3.2"), new HttpResponseStatusHelper(202, HttpResponseStatus.ACCEPTED, "Accepted", "https://tools.ietf.org/html/rfc7231#section-6.3.3"), new HttpResponseStatusHelper(203, HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION, "Non-Authoritative Information", "https://tools.ietf.org/html/rfc7231#section-6.3.4"), new HttpResponseStatusHelper(204, HttpResponseStatus.NO_CONTENT, "No Content", "https://tools.ietf.org/html/rfc7231#section-6.3.5"), new HttpResponseStatusHelper(205, HttpResponseStatus.RESET_CONTENT, "Reset Content", "https://tools.ietf.org/html/rfc7231#section-6.3.6"), new HttpResponseStatusHelper(206, HttpResponseStatus.PARTIAL_CONTENT, "Partial Content", "https://tools.ietf.org/html/rfc7233#section-4.1"), new HttpResponseStatusHelper(300, HttpResponseStatus.MULTIPLE_CHOICES, "Multiple Choices", "https://tools.ietf.org/html/rfc7231#section-6.4.1"), new HttpResponseStatusHelper(301, HttpResponseStatus.MOVED_PERMANENTLY, "Moved Permanently", "https://tools.ietf.org/html/rfc7231#section-6.4.2"), new HttpResponseStatusHelper(302, HttpResponseStatus.FOUND, "Found", "https://tools.ietf.org/html/rfc7231#section-6.4.3"), new HttpResponseStatusHelper(303, HttpResponseStatus.SEE_OTHER, "See Other", "https://tools.ietf.org/html/rfc7231#section-6.4.4"), new HttpResponseStatusHelper(304, HttpResponseStatus.NOT_MODIFIED, "Not Modified", "https://tools.ietf.org/html/rfc7232#section-4.1"), new HttpResponseStatusHelper(305, HttpResponseStatus.USE_PROXY, "Use Proxy", "https://tools.ietf.org/html/rfc7231#section-6.4.5"), new HttpResponseStatusHelper(307, HttpResponseStatus.TEMPORARY_REDIRECT, "Temporary Redirect", "https://tools.ietf.org/html/rfc7231#section-6.4.7"), new HttpResponseStatusHelper(400, HttpResponseStatus.BAD_REQUEST, "Bad Request", "https://tools.ietf.org/html/rfc7231#section-6.5.1"), new HttpResponseStatusHelper(401, HttpResponseStatus.UNAUTHORIZED, "Unauthorized", "https://tools.ietf.org/html/rfc7235#section-3.1"), new HttpResponseStatusHelper(402, HttpResponseStatus.PAYMENT_REQUIRED, "Payment Required", "https://tools.ietf.org/html/rfc7231#section-6.5.2"), new HttpResponseStatusHelper(403, HttpResponseStatus.FORBIDDEN, "Forbidden", "https://tools.ietf.org/html/rfc7231#section-6.5.3"), new HttpResponseStatusHelper(404, HttpResponseStatus.NOT_FOUND, "Not Found", "https://tools.ietf.org/html/rfc7231#section-6.5.4"), new HttpResponseStatusHelper(405, HttpResponseStatus.METHOD_NOT_ALLOWED, "Method Not Allowed", "https://tools.ietf.org/html/rfc7231#section-6.5.5"), new HttpResponseStatusHelper(406, HttpResponseStatus.NOT_ACCEPTABLE, "Not Acceptable", "https://tools.ietf.org/html/rfc7231#section-6.5.6"), new HttpResponseStatusHelper(407, HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED, "Proxy Authentication Required", "https://tools.ietf.org/html/rfc7235#section-3.2"), new HttpResponseStatusHelper(408, HttpResponseStatus.REQUEST_TIMEOUT, "Request Timeout", "https://tools.ietf.org/html/rfc7231#section-6.5.7"), new HttpResponseStatusHelper(409, HttpResponseStatus.CONFLICT, "Conflict", "https://tools.ietf.org/html/rfc7231#section-6.5.8"), new HttpResponseStatusHelper(410, HttpResponseStatus.GONE, "Gone", "https://tools.ietf.org/html/rfc7231#section-6.5.9"), new HttpResponseStatusHelper(411, HttpResponseStatus.LENGTH_REQUIRED, "Length Required", "https://tools.ietf.org/html/rfc7231#section-6.5.10"), new HttpResponseStatusHelper(412, HttpResponseStatus.PRECONDITION_FAILED, "Precondition Failed", "https://tools.ietf.org/html/rfc7232#section-4.2"), new HttpResponseStatusHelper(413, HttpResponseStatus.PAYLOAD_TOO_LARGE, "Payload Too Large", "https://tools.ietf.org/html/rfc7231#section-6.5.11"), new HttpResponseStatusHelper(414, HttpResponseStatus.URI_TOO_LONG, "URI Too Long", "https://tools.ietf.org/html/rfc7231#section-6.5.12"), new HttpResponseStatusHelper(415, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE, "Unsupported Media Type", "https://tools.ietf.org/html/rfc7231#section-6.5.13"), new HttpResponseStatusHelper(416, HttpResponseStatus.RANGE_NOT_SATISFIABLE, "Range Not Satisfiable", "https://tools.ietf.org/html/rfc7233#section-4.4"), new HttpResponseStatusHelper(417, HttpResponseStatus.EXPECTATION_FAILED, "Expectation Failed", "https://tools.ietf.org/html/rfc7231#section-6.5.14"), new HttpResponseStatusHelper(426, HttpResponseStatus.UPGRADE_REQUIRED, "Upgrade Required", "https://tools.ietf.org/html/rfc7231#section-6.5.15"), new HttpResponseStatusHelper(500, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Internal Server Error", "https://tools.ietf.org/html/rfc7231#section-6.6.1"), new HttpResponseStatusHelper(501, HttpResponseStatus.NOT_IMPLEMENTED, "Not Implemented", "https://tools.ietf.org/html/rfc7231#section-6.6.2"), new HttpResponseStatusHelper(502, HttpResponseStatus.BAD_GATEWAY, "Bad Gateway", "https://tools.ietf.org/html/rfc7231#section-6.6.3"), new HttpResponseStatusHelper(503, HttpResponseStatus.SERVICE_UNAVAILABLE, "Service Unavailable", "https://tools.ietf.org/html/rfc7231#section-6.6.4"), new HttpResponseStatusHelper(504, HttpResponseStatus.GATEWAY_TIMEOUT, "Gateway Timeout", "https://tools.ietf.org/html/rfc7231#section-6.6.5"), new HttpResponseStatusHelper(505, HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED, "HTTP Version Not Supported", "https://tools.ietf.org/html/rfc7231#section-6.6.6")}) {
            helperByStatus.put(helper.status, helper);
            helperByCode.put(helper.code, helper);
            switch (helper.code / 100) {
                case 1: {
                    informationalStatuses.add(helper.status);
                    informationalCodes.add(helper.code);
                    continue block7;
                }
                case 2: {
                    successfulStatuses.add(helper.status);
                    successfulCodes.add(helper.code);
                    continue block7;
                }
                case 3: {
                    redirectionStatuses.add(helper.status);
                    redirectionCodes.add(helper.code);
                    continue block7;
                }
                case 4: {
                    clientErrorStatuses.add(helper.status);
                    clientErrorCodes.add(helper.code);
                    continue block7;
                }
                case 5: {
                    serverErrorStatuses.add(helper.status);
                    serverErrorCodes.add(helper.code);
                }
            }
        }
    }
}

