/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.FunctionType;
import java.util.HashMap;
import java.util.Map;

public class FunctionTypeHelper {
    private static final Map<FunctionType, FunctionTypeHelper> functionTypes = new HashMap<FunctionType, FunctionTypeHelper>();
    private final String displayName;

    private FunctionTypeHelper(String displayName) {
        this.displayName = displayName;
    }

    public static String getDisplayName(FunctionType functionType) {
        FunctionTypeHelper helper = functionTypes.get(functionType);
        if (helper != null) {
            return helper.displayName;
        }
        return null;
    }

    static {
        functionTypes.put(FunctionType.MIN, new FunctionTypeHelper("minimum value"));
        functionTypes.put(FunctionType.MAX, new FunctionTypeHelper("maximum value"));
        functionTypes.put(FunctionType.VALUE, new FunctionTypeHelper("value"));
        functionTypes.put(FunctionType.SUM, new FunctionTypeHelper("sum value"));
        functionTypes.put(FunctionType.COUNT, new FunctionTypeHelper("count"));
        functionTypes.put(FunctionType.GROUP_COUNT, new FunctionTypeHelper("group count"));
        functionTypes.put(FunctionType.OCCURRENCES, new FunctionTypeHelper("occurrences"));
        functionTypes.put(FunctionType.CURRENT, new FunctionTypeHelper("current value"));
    }
}

