/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.EntityType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityTypeHelper {
    private static final Map<EntityType, EntityTypeHelper> entityTypes = new HashMap<EntityType, EntityTypeHelper>();
    private static final List<EntityType> ENTITY_TYPES = Collections.unmodifiableList(Arrays.asList(EntityType.values()));
    private final String displayName;

    private EntityTypeHelper(String displayName) {
        this.displayName = displayName;
    }

    public static String getDisplayName(EntityType entityType) {
        EntityTypeHelper helper = entityTypes.get(entityType);
        if (helper != null) {
            return helper.displayName;
        }
        return null;
    }

    public static EntityType toEntityTypeEnum(String entityType) {
        EntityType type = null;
        if (entityType != null) {
            type = EntityType.valueOf((String)entityType);
        }
        return type;
    }

    public static EntityType fromOrdinal(int ordinal) {
        if (ordinal >= ENTITY_TYPES.size() || ordinal < 0) {
            return null;
        }
        return ENTITY_TYPES.get(ordinal);
    }

    public static List<EntityType> getEntityTypes() {
        return ENTITY_TYPES;
    }

    static {
        entityTypes.put(EntityType.ACCOUNT, new EntityTypeHelper("Account"));
        entityTypes.put(EntityType.AGENT_CONFIGURATION, new EntityTypeHelper("Agent Configuration"));
        entityTypes.put(EntityType.ALL, new EntityTypeHelper("All"));
        entityTypes.put(EntityType.APPLICATION, new EntityTypeHelper("Application"));
        entityTypes.put(EntityType.APPLICATION_COMPONENT, new EntityTypeHelper("Tier"));
        entityTypes.put(EntityType.APPLICATION_COMPONENT_NODE, new EntityTypeHelper("Node"));
        entityTypes.put(EntityType.APPLICATION_DIAGNOSTIC_DATA, new EntityTypeHelper("Error Rates"));
        entityTypes.put(EntityType.AUTOMATIC_LEAK_DETECTION, new EntityTypeHelper("Automatic Leak Detection"));
        entityTypes.put(EntityType.BACKEND, new EntityTypeHelper("Backend"));
        entityTypes.put(EntityType.BACKEND_DISCOVERY_CONFIG, new EntityTypeHelper("Backend Discovery Config"));
        entityTypes.put(EntityType.BUSINESS_TRANSACTION, new EntityTypeHelper("Business Transaction"));
        entityTypes.put(EntityType.BUSINESS_TRANSACTION_GROUP, new EntityTypeHelper("Business Transaction Group"));
        entityTypes.put(EntityType.CALL_GRAPH_CONFIGURATION, new EntityTypeHelper("Call Graph Configuration"));
        entityTypes.put(EntityType.CUSTOM_EXIT_POINT_DEFINITION, new EntityTypeHelper("Custom Exit Point Definition"));
        entityTypes.put(EntityType.CUSTOM_MATCH_POINT_DEFINITION, new EntityTypeHelper("Custom Match Point Definition"));
        entityTypes.put(EntityType.CUSTOM_MEMORY_STRUCTURE, new EntityTypeHelper("Custom Memory Structure"));
        entityTypes.put(EntityType.DASHBOARD, new EntityTypeHelper("Dashboard"));
        entityTypes.put(EntityType.ERROR, new EntityTypeHelper("Error"));
        entityTypes.put(EntityType.ERROR_CONFIGURATION, new EntityTypeHelper("Error Configuration"));
        entityTypes.put(EntityType.ERROR_CONFIGURATION_SUBCOMPONENT, new EntityTypeHelper("Entity Error Configuration"));
        entityTypes.put(EntityType.DOT_NET_ERROR_CONFIGURATION, new EntityTypeHelper("Dotnet Error Configuration"));
        entityTypes.put(EntityType.DOTNET_ERROR_CONFIGURATION_SUBCOMPONENT, new EntityTypeHelper("Dotnet Error Configuration Subcomponent"));
        entityTypes.put(EntityType.PHP_ERROR_CONFIGURATION, new EntityTypeHelper("Php Error Configuration"));
        entityTypes.put(EntityType.WEBSERVER_ERROR_CONFIGURATION, new EntityTypeHelper("Webserver Error Configuration"));
        entityTypes.put(EntityType.NODEJS_ERROR_CONFIGURATION, new EntityTypeHelper("Node.js Error Configuration"));
        entityTypes.put(EntityType.PYTHON_ERROR_CONFIGURATION, new EntityTypeHelper("Python Error Configuration"));
        entityTypes.put(EntityType.RUBY_ERROR_CONFIGURATION, new EntityTypeHelper("Ruby Error Configuration"));
        entityTypes.put(EntityType.EUM_CONFIGURATION, new EntityTypeHelper("EUM Configuration"));
        entityTypes.put(EntityType.EVENT, new EntityTypeHelper("Event"));
        entityTypes.put(EntityType.GLOBAL_CONFIGURATION, new EntityTypeHelper("Global Configuration"));
        entityTypes.put(EntityType.INCIDENT, new EntityTypeHelper("Incident"));
        entityTypes.put(EntityType.JMX_CONFIG, new EntityTypeHelper("JMX Config"));
        entityTypes.put(EntityType.MACHINE_INSTANCE, new EntityTypeHelper("Machine Instance"));
        entityTypes.put(EntityType.MEMORY_CONFIGURATION, new EntityTypeHelper("Memory Configuration"));
        entityTypes.put(EntityType.NOTIFICATION_CONFIG, new EntityTypeHelper("Notification Config"));
        entityTypes.put(EntityType.OBJECT_INSTANCE_TRACKING, new EntityTypeHelper("Object Instance Tracking"));
        entityTypes.put(EntityType.POLICY, new EntityTypeHelper("Health Rule"));
        entityTypes.put(EntityType.RULE, new EntityTypeHelper("Rule"));
        entityTypes.put(EntityType.SQL_DATA_GATHERER_CONFIG, new EntityTypeHelper("Sql Data Gatherer Config"));
        entityTypes.put(EntityType.STACK_TRACE, new EntityTypeHelper("Stacktrace"));
        entityTypes.put(EntityType.THREAD_TASK, new EntityTypeHelper("Thread task"));
        entityTypes.put(EntityType.TRANSACTION_MATCH_POINT_CONFIG, new EntityTypeHelper("Transaction Matchpoint config"));
        entityTypes.put(EntityType.USER, new EntityTypeHelper("User"));
        entityTypes.put(EntityType.GROUP, new EntityTypeHelper("Group"));
        entityTypes.put(EntityType.ACCOUNT_ROLE, new EntityTypeHelper("Account Role"));
        entityTypes.put(EntityType.WORKFLOW, new EntityTypeHelper("Workflow"));
        entityTypes.put(EntityType.WORKFLOW_EXCUTION, new EntityTypeHelper("Workflow execution"));
        entityTypes.put(EntityType.POJO_DATA_GATHERER_CONFIG, new EntityTypeHelper("Pojo data gatherer"));
        entityTypes.put(EntityType.HTTP_REQUEST_DATA_GATHERER_CONFIG, new EntityTypeHelper("http request data gatherer config"));
        entityTypes.put(EntityType.BASE_PAGE, new EntityTypeHelper("Page"));
        entityTypes.put(EntityType.IFRAME, new EntityTypeHelper("IFrame"));
        entityTypes.put(EntityType.VIRTUAL_PAGE, new EntityTypeHelper("Virtual Page"));
        entityTypes.put(EntityType.AJAX_REQUEST, new EntityTypeHelper("Ajax Request"));
        entityTypes.put(EntityType.INFO_POINT, new EntityTypeHelper("Information Point"));
        entityTypes.put(EntityType.MOBILE_NETWORK_REQUEST, new EntityTypeHelper("Mobile Network Request"));
        entityTypes.put(EntityType.MOBILE_APPLICATION, new EntityTypeHelper("Mobile Application"));
        entityTypes.put(EntityType.DB_SERVER, new EntityTypeHelper("DB Server"));
        entityTypes.put(EntityType.DB_MONITOR_CONFIG, new EntityTypeHelper("DB Collector"));
        entityTypes.put(EntityType.JMX_INSTANCE_NAME, new EntityTypeHelper("JMX Instance Name"));
        entityTypes.put(EntityType.METRIC, new EntityTypeHelper("Metric"));
        entityTypes.put(EntityType.SERVICE_END_POINT, new EntityTypeHelper("Service Endpoint"));
        entityTypes.put(EntityType.DB_AGENT, new EntityTypeHelper("DB Agent"));
        entityTypes.put(EntityType.EVENT_REACTOR, new EntityTypeHelper("Policy"));
        entityTypes.put(EntityType.ACTION, new EntityTypeHelper("Action"));
        entityTypes.put(EntityType.OVERAGE_EVENT_TYPE, new EntityTypeHelper("Overage Event"));
        entityTypes.put(EntityType.SYNTH_JOB_REF, new EntityTypeHelper("Synthetic Job"));
    }
}

