/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.EventType;
import java.util.Collection;
import java.util.LinkedList;

public class EUMEventTypeHelper {
    private static final Collection<EventType> synthJobEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> browserSnapshotEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> mobileSnapshotEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> mobileCrashEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> mobileAlertEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> allMobileEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> allEumSnapshotEventTypes = new LinkedList<EventType>();
    private static final Collection<EventType> allEumEventTypes = new LinkedList<EventType>();

    public static Collection<EventType> getMobileCrashEventTypes() {
        return mobileCrashEventTypes;
    }

    public static Collection<EventType> getMobileAlertEventTypes() {
        return mobileAlertEventTypes;
    }

    public static Collection<EventType> getMobileSnapshotEventTypes() {
        return mobileSnapshotEventTypes;
    }

    public static Collection<EventType> getAllMobileEventTypes() {
        return allMobileEventTypes;
    }

    public static Collection<EventType> getSynthJobEventTypes() {
        return synthJobEventTypes;
    }

    public static Collection<EventType> getBrowserSnapshotEventTypes() {
        return browserSnapshotEventTypes;
    }

    public static Collection<EventType> getAllEumSnapshotEventTypes() {
        return allEumSnapshotEventTypes;
    }

    public static Collection<EventType> getAllEumEventTypes() {
        return allEumEventTypes;
    }

    public static void validateEventTypeOrDie(EventType eventType, Collection<EventType> col) throws Exception {
        if (!col.contains(eventType)) {
            throw new IllegalArgumentException("Illegal event type: " + eventType + ", expected one of: " + col);
        }
    }

    public static boolean isSynthetic(EventType eventType) {
        return eventType == EventType.EUM_CLOUD_SYNTHETIC_BROWSER_EVENT;
    }

    static {
        EUMEventTypeHelper.getBrowserSnapshotEventTypes().add(EventType.EUM_CLOUD_BROWSER_EVENT);
        EUMEventTypeHelper.getBrowserSnapshotEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_BROWSER_EVENT);
        EUMEventTypeHelper.getMobileSnapshotEventTypes().add(EventType.MOBILE_SNAPSHOT_IOS_EVENT);
        EUMEventTypeHelper.getMobileSnapshotEventTypes().add(EventType.MOBILE_SNAPSHOT_ANDROID_EVENT);
        EUMEventTypeHelper.getMobileCrashEventTypes().add(EventType.MOBILE_CRASH_IOS_EVENT);
        EUMEventTypeHelper.getMobileCrashEventTypes().add(EventType.MOBILE_CRASH_ANDROID_EVENT);
        EUMEventTypeHelper.getMobileAlertEventTypes().add(EventType.MOBILE_NEW_CRASH_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_HEALTHY_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_WARNING_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_WARNING_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_WARNING_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_ERROR_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_ERROR_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_ERROR_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_HEALTHY_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_WARNING_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_WARNING_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_WARNING_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_CRITICAL_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_CRITICAL_EVENT);
        EUMEventTypeHelper.getSynthJobEventTypes().add(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_CRITICAL_EVENT);
        EUMEventTypeHelper.getAllMobileEventTypes().addAll(EUMEventTypeHelper.getMobileSnapshotEventTypes());
        EUMEventTypeHelper.getAllMobileEventTypes().addAll(EUMEventTypeHelper.getMobileCrashEventTypes());
        EUMEventTypeHelper.getAllMobileEventTypes().addAll(EUMEventTypeHelper.getMobileAlertEventTypes());
        EUMEventTypeHelper.getAllEumSnapshotEventTypes().addAll(EUMEventTypeHelper.getBrowserSnapshotEventTypes());
        EUMEventTypeHelper.getAllEumSnapshotEventTypes().addAll(EUMEventTypeHelper.getMobileSnapshotEventTypes());
        EUMEventTypeHelper.getAllEumEventTypes().addAll(EUMEventTypeHelper.getAllMobileEventTypes());
        EUMEventTypeHelper.getAllEumEventTypes().addAll(EUMEventTypeHelper.getBrowserSnapshotEventTypes());
        EUMEventTypeHelper.getAllEumEventTypes().addAll(EUMEventTypeHelper.getSynthJobEventTypes());
    }
}

